#!/bin/bash
set -e

# Base directories
BASE_DIR="/mnt/m/Github/chac-workbench/case-study/A07_Academic_Paper_Preparation_and_Asset_Collection"
SOURCE_DIR="$BASE_DIR/temp_asset_collection"
DEST_DIR="$BASE_DIR/A07_renamed_assets"
MANIFEST_FILE="$BASE_DIR/A07_asset_manifest.md"

# Clean up and create destination
rm -rf "$DEST_DIR"
mkdir -p "$DEST_DIR"

# Initialize manifest file
echo "# Asset Manifest" > "$MANIFEST_FILE"
echo "" >> "$MANIFEST_FILE"
echo "This file maps the renamed and blocked assets back to their original source paths inside 'temp_asset_collection'." >> "$MANIFEST_FILE"
echo "" >> "$MANIFEST_FILE"
echo "| New Filename | Original Path in temp_asset_collection |
|---|---|" >> "$MANIFEST_FILE"

# Find all files, iterate, copy with new name, and record in manifest
find "$SOURCE_DIR" -type f | sort | while read -r filepath; do
    # Get the parent directory name (e.g., A01_Profile_Co-Creation_SOP_Validation)
    parent_dir=$(basename "$(dirname "$filepath")")
    
    # Get the original filename
    original_filename=$(basename "$filepath")
    
    # Create the new filename
    new_filename="${parent_dir}_${original_filename}"
    
    # Copy the file to the destination with the new name
    cp "$filepath" "$DEST_DIR/$new_filename"
    
    # Get relative original path for the manifest
    relative_original_path=${filepath#"$BASE_DIR/"}

    # Append the mapping to the manifest file
    echo "| \`$new_filename\` | \`$relative_original_path\` |
" >> "$MANIFEST_FILE"
done

echo "Renaming complete. Manifest generated at $MANIFEST_FILE"
