# A08 - Record 01: Distributed Asset Analysis Protocol (DAAP) v2 Design

**Parent Case:** A08_Analyze_and_Integrate_A07_Asset_Package
**Topic:** The formal design of a robust, web-client-compatible protocol for the distributed analysis of the A07 asset package.

---

## 1.0 Objective

To design a standardized, self-contained, and reproducible protocol that allows the Visionary Architect to delegate the analysis of historical project assets to multiple, independent AI sessions within a web-client environment that lacks a file system.

## 2.0 Problem Statement & Design Constraint

The initial protocol design (DAAP v1) implicitly assumed that the analyzing AI would have file system access, mirroring the capabilities of the primary AI. The Architect identified a critical new constraint: the analysis would be performed in a web client, which has no access to the project's file structure. This constraint rendered DAAP v1 unusable and necessitated a complete redesign.

The core design challenge is to create a protocol that is **entirely self-contained within a single prompt**, removing all dependencies on an external file system.

## 3.0 Protocol Design: DAAP v2

The protocol consists of three core components: a specialized system prompt for the analyst AI, a Standard Operating Procedure (SOP) for the Architect, and a strict data schema for the output.

### 3.1 Part 1: Refactored System Prompt (Context-Only Analyst)

This prompt is designed to instantiate a temporary, specialized AI analyst whose entire operational context is provided at runtime.

```markdown
# System Prompt: CHAC Specialized Research Analyst (Context-Only)

## 1. Core Identity & Objective

You are a Specialized Research Analyst. Your entire operational context is provided within a single prompt from the user. Your sole objective is to analyze a piece of text (the "Asset Content") based on a provided framework and output a single, structured JSON object.

## 2. Core Task & Context Structure

The user will provide you with a single, comprehensive prompt. This prompt contains your entire universe of information, structured in three parts:

1.  **The Asset Manifest Content:** A markdown table listing all assets in the project.
2.  **The Analysis Framework Content:** A document outlining the specific "Mandatory Argumentative Elements" you must use for your analysis.
3.  **The Asset Content for Analysis:** The full text of the specific document you are to analyze in this session.

Your task is to:
1.  Read and understand all three parts of the provided context.
2.  Analyze the **Asset Content for Analysis** *exclusively* through the lens of the elements described in the **Analysis Framework Content**.
3.  Generate a single JSON object containing your structured analysis.

## 3. Constraints & Guardrails (Non-negotiable)

*   **Context-Bound:** You have no memory of past conversations and no ability to access external files. All your knowledge comes from the single prompt you are given. Do not attempt to find, read, or write files.
*   **Framework Adherence:** Your analysis *must* directly address the elements from the Analysis Framework. If an asset has no relevance to a particular element, you must explicitly state that in your JSON output. Do not provide a generic summary.
*   **Honesty:** If the provided Asset Content is insufficient for analysis, state this clearly in the `notes` section of your output. Do not invent or infer information.
*   **Output Format:** Your final and only output MUST be a single, raw JSON object. Do not wrap it in Markdown, add explanatory text before or after it, or engage in any form of conversation.
```

### 3.2 Part 2: Standard Operating Procedure (SOP) for Web Client

This SOP provides a step-by-step guide for the Architect to manage the analysis process.

1.  **Preparation:** Locally create a directory `A08_analyses` to store results. Prepare the full text content of `A07_asset_manifest.md`, `M75_record_03...md`, and the target asset file.
2.  **Session Initiation:** For each asset in the manifest, start a new, clean web chat session. Paste the System Prompt from Part 1 to initialize the analyst AI.
3.  **Task Invocation:** In a single, subsequent prompt, provide the full text content of the Manifest, the Framework, and the target Asset, using a clear template to delineate each section.
4.  **Output Collection:** Copy the raw JSON output from the AI.
5.  **Data Storage:** Create a new local file named `[original_filename]_analysis.json` in the `A08_analyses` directory and paste the copied JSON content into it.
6.  **Iteration:** Close the session and repeat for the next asset.

### 3.3 Part 3: Expected Output JSON Schema

The output from each analysis session must conform to this structure to ensure programmatic consolidation is possible.

```json
{
  "source_filename": "string",
  "asset_category": "string (P1, P2, or P3)",
  "analysis_summary": "string",
  "relevance_to_m75_elements": {
    "element_1_critical_positioning": "string",
    "element_2_golden_failure": "string",
    "element_3_architect_evolution": "string",
    "element_4_compensatory_engineering": "string"
  },
  "key_quotes": ["string"],
  "confidence_score": "integer (1-5)",
  "notes": "string"
}
```

## 4.0 Analysis and Rationale

This v2 protocol is significantly more robust than its predecessor because it makes no assumptions about the execution environment beyond the AI's core capabilities. By shifting all dependencies from the file system to the prompt context, it becomes a portable, self-contained "analysis package." This embodies the "Dependency Abstraction" principle and ensures the integrity and consistency of the results, regardless of who or what is performing the analysis.
