#!/bin/bash
# This script consolidates all necessary paper assets into a single directory.

set -e
echo "Starting asset consolidation..."

# Define target directory
TARGET_DIR="case-study/A07_Academic_Paper_Preparation_and_Asset_Collection/temp_asset_collection"
echo "Target directory: $TARGET_DIR"

# Ensure target directory exists and is clean
mkdir -p "$TARGET_DIR"

# --- List of all source files ---
SOURCE_FILES=(
    "/mnt/m/Github/chac-workbench/case-study/M75_Design_of_AI-Led_Verbatim_Log_Analysis/M75_record_01_a4s_paper_constitution_and_outline.md"
    "/mnt/m/Github/chac-workbench/case-study/M75_Design_of_AI-Led_Verbatim_Log_Analysis/M75_record_03_mandatory_argumentative_elements_for_a4s_paper.md"
    "/mnt/m/Github/chac-workbench/case-study/M75_Design_of_AI-Led_Verbatim_Log_Analysis/M75_record_02_analysis_and_visualization_plan.md"
    "/mnt/m/Github/chac-workbench/case-study/A06_Drafting_A4S_Related_Work_Section/README.md"
    "/mnt/m/Github/chac-workbench/case-study/M74_Structured_Transformation_of_Verbatim_Logs/README.md"
    "/mnt/m/Github/chac-workbench/case-study/A05_Drafting_the_A4S_Paper/README.md"
    "/mnt/m/Github/chac-workbench/case-study/A02_Portable_System_Prompt_Design/final_toolkit_snapshot/README.md"
    "/mnt/m/Github/chac-workbench/case-study/A02_Portable_System_Prompt_Design/README.md"
    "/mnt/m/Github/chac-workbench/case-study/M53_AI-Native_Toolkit_Refactoring/README.md"
    "/mnt/m/Github/chac-workbench/case-study/README.md"
    "/mnt/m/Github/chac-workbench/case-study/M75_Design_of_AI-Led_Verbatim_Log_Analysis/report/CHAC-SD-OTRjMzBi-20250821_report_draft.md"
    "/mnt/m/Github/chac-workbench/case-study/A06_Drafting_A4S_Related_Work_Section/report/CHAC-SD-MWVkNTZi-20250814_report_draft.md"
    "/mnt/m/Github/chac-workbench/case-study/M74_Structured_Transformation_of_Verbatim_Logs/report/CHAC-SD-YmFmZWI1-20250820_report.md"
    "/mnt/m/Github/chac-workbench/case-study/A05_Drafting_the_A4S_Paper/report/A05_Report_Part1_Initial-Lit-Review.md"
    "/mnt/m/Github/chac-workbench/case-study/A01_Profile_Co-Creation_SOP_Validation/report/CHAC-SD-20250717-69_report.md"
    "/mnt/m/Github/chac-workbench/case-study/A02_Portable_System_Prompt_Design/report/CHAC-SD-20250718-65_report.md"
    "/mnt/m/Github/chac-workbench/case-study/A04_Executing_Phase_2:_Small-Scale_Qualitative_Validation/report/CHAC-SD-N2ZiMWEy-20250810_report_draft.md"
    "/mnt/m/Github/chac-workbench/case-study/A05_Drafting_the_A4S_Paper/report/A05_Report_Part2_Academic-Positioning.md"
    "/mnt/m/Github/chac-workbench/case-study/A05_Drafting_the_A4S_Paper/report/A05_Report_Part3_Final-Synthesis.md"
    "/mnt/m/Github/chac-workbench/chac_toolkit/CHAC_System_Prompt_Builder.sh"
    "/mnt/m/Github/chac-workbench/case-study/A02_Portable_System_Prompt_Design/build_config.json"
    "/mnt/m/Github/chac-workbench/case-study/M74_Structured_Transformation_of_Verbatim_Logs/transform_log.py"
    "/mnt/m/Github/chac-workbench/case-study/M74_Structured_Transformation_of_Verbatim_Logs/M74_data_schema.md"
)

# --- Function to extract case ID and copy files ---
process_file() {
    local original_path=$1
    local case_id
    local new_filename
    
    # Extract case ID (e.g., M75, A06)
    if [[ $original_path =~ case-study/([MA][0-9]+)_ ]]; then
        case_id="${BASH_REMATCH[1]}"
    else
        case_id="GENERAL"
    fi
    
    original_filename=$(basename "$original_path")
    new_filename="${case_id}_${original_filename}"
    
    echo "Copying '$original_path' to '$TARGET_DIR/$new_filename'"
    cp "$original_path" "$TARGET_DIR/$new_filename"
}

# --- Process all files ---
for file in "${SOURCE_FILES[@]}"; do
    process_file "$file"
done

# --- Special handling for A05 records directory ---
A05_RECORDS_DIR="/mnt/m/Github/chac-workbench/case-study/A05_Drafting_the_A4S_Paper/records"
if [ -d "$A05_RECORDS_DIR" ]; then
    echo "Processing A05 records directory..."
    for file in "$A05_RECORDS_DIR"/*.md; do
        if [ -f "$file" ]; then
            process_file "$file"
        fi
    done
fi

echo "Asset consolidation complete."
echo "$(ls -1q "$TARGET_DIR" | wc -l) files consolidated into $TARGET_DIR"

