# Documentation: Case Study Concept Relevance Analysis

This document outlines the purpose, functionality, and usage of the `analysis_script.py` and its output, `case_study_concept_relevance.csv`.

## 1. Purpose

The primary goal of this analysis is to systematically quantify the relationship between each case study (e.g., A01, M75) and the core concepts of the CHAC framework.

The process involves:
1.  Reading the detailed, qualitative analysis of project assets stored in multiple JSON files.
2.  Aggregating this data to calculate a quantitative measure of relevance.
3.  Producing a clean, summary CSV report that shows the average relevance of each concept to each case study.

## 2. File Descriptions

### `analysis_script.py`
- **Purpose**: A Python script designed to automate the analysis process.
- **Functionality**:
    - It scans the `asset_analysis_outputs/` directory and reads all `.json` files.
    - For each record, it extracts the case study ID from the `source_filename`.
    - **Special Logic**: It identifies all assets from the `A05` case study and groups them under the special identifier `A05_literature_review` to distinguish them from other case studies.
    - It aggregates the `relevance` scores for each concept within a given case study.
    - It calculates the average relevance score for each `(case_study, concept)` pair.
    - It writes the final, sorted results to `case_study_concept_relevance.csv`.
- **Dependencies**: This script is intentionally dependency-free and uses only standard Python 3 libraries to ensure maximum portability and avoid environment-related issues.

### `asset_analysis_outputs/*.json` (Input)
- **Description**: These are the raw input files containing the detailed analysis of individual project assets. Each record within these files links a specific asset (like a report or a config file) to one or more core CHAC concepts and provides a numerical relevance score.

### `case_study_concept_relevance.csv` (Output)
- **Description**: This is the final, aggregated report generated by the script. It provides a high-level overview of which concepts are most prominent in each case study.
- **Columns**:
    - `case_study`: The unique identifier for the case study (e.g., `A01`, `M75`, `A05_literature_review`).
    - `concept`: The core CHAC concept being evaluated.
    - `average_relevance`: The calculated average relevance score of the concept to that case study, based on all mentions across all related source assets.

## 3. How to Run the Analysis

To regenerate the `case_study_concept_relevance.csv` report, follow these steps:

1.  **Navigate to the project root directory**:
    ```bash
    cd /mnt/m/Github/chac-workbench
    ```

2.  **Execute the script using Python 3**:
    ```bash
    python3 case-study/A08_Analyze_and_Integrate_A07_Asset_Package/analysis_script.py
    ```

3.  **Verify the Output**:
    The script will print a confirmation message to the console upon successful completion. The updated `case_study_concept_relevance.csv` file will be located in the `case-study/A08_Analyze_and_Integrate_A07_Asset_Package/` directory.
