### **固化文档：通过“单一事实来源”原则实现文档架构的最终纯粹性**
* **文档ID:** CHAC-SD-20250715-15
* **版本:** 1.0
* **创建日期:** 2025-07-15
* **创建者:** The Visionary Architect & The Compensatory Engineer

---

#### **1.0 核心模块 (Core Module)**

**1.1 核心洞见与定义**
*   **核心洞见:** 一个优雅的、可维护的系统，其文档架构必须同时满足“架构纯粹性”（无冗余）和“人类可用性”（易于理解）。最终的、最理想的解决方案，是通过让根目录的`README.md`承担“导航图”和“意图说明书”的职责，来完美调和这一核心张力。
*   **“文档受众分离 (Audience-Specific Documentation)”原则:** 这是一个核心的设计原则，即为不同的受众（人类 vs. AI）提供不同的、命名清晰的文档。例如，`README.md`是为人类准备的，而`AI_INSTRUCTIONS.md`是为AI准备的。
*   **“单一事实来源 (Single Source of Truth - SSoT)”原则:** 在文档架构中，关于某个特定主题的、权威的解释，应该只存在于一个地方。例如，关于整个项目架构的解释，其SSoT是根目录的`README.md`。所有其他地方的文档，都应该是指向��SSoT的指针，而不是重复其内容。这极大地降低了未来的维护成本。

**1.2 应用指南与推荐策略**
*   **策略:** 在设计任何文档或代码结构时，都应主动思考：“当未来需求变化时，我需要修改几个地方？”，并努力将答案优化为“一个”。
*   **操作指南:** 根目录的`README.md`是项目的最高导航，应详尽。子目录的`README.md`应保持简洁，并指引用户回到根`README.md`获取全局上下文。

---

### **附录 (Appendix): 创作过程追溯档案**

**A.1 否决草稿档案**
*   **草稿版本:** “将`chac_toolkit/README.md`作为AI指令集”
*   **总结:** 该方案建议将`README.md`这个约定俗成给人类阅读的文件，改变用途，作为给AI的指令脚本。
*   **否决原因:** 架构师指出，这违反了“文档受众分离”的核心设计原则，会给任何不了解背景的人类用户带来困惑，是一种“反模式”。
*   **草稿版本:** “在根目录创建`AI_INSTRUCTION.md`”
*   **总结:** 该方案建议在根目录创建一个`AI_INSTRUCTION.md`文件，以提高人类用户的“可发现性”。
*   **否决原因:** 架构师指出，这虽然解决了“可发现性”问题，但却以牺牲“架构纯粹性”为代价，造成了文档的冗余。最终的、更优越的方���是，让根目录的`README.md`承担起“导航图”和“意图说明书”的职责。
