# M15 Final Report: Analysis of Protocol Version Inconsistency

**ID:** CHAC-SD-20250715-36
**Case:** M15_Protocol_Version_Inconsistency

---

## 1. What: The Problem

A recurring initialization error was identified where the AI, upon startup, would report its operational protocol as "v5.7" despite the core system files (`AI_System_Prompt.md`, `CHAC_Core_Philosophy.md`) being updated to "v6.2". This created a contradiction and required manual correction by the user in every session.

## 2. Why: The Root Cause

The error stemmed from a documentation inconsistency within the AI's sequential initialization process.

1.  **Initial Instruction:** The first file read by the AI is `chac_toolkit/AI_INSTRUCTIONS.md`. This file acts as a bootloader.
2.  **Outdated Hardcoded Value:** This bootloader file contained a hardcoded, static instruction to report "CHAC Protocol V5.7 engaged" at the end of the initialization sequence.
3.  **Sequential Execution:** The AI, bound by its protocols to follow instructions literally, would execute this command, leading to the incorrect version report.
4.  **Delayed Correction:** Only after this initial (and incorrect) confirmation would the AI have fully loaded the more authoritative core protocol files that specified the correct v6.2.

The core failure was that the bootloader file was not updated when the main protocol version was incremented.

## 3. How: The Resolution

A two-part resolution was implemented:

1.  **Immediate Fix (Dynamic Instruction):** The user proposed a more robust, future-proof solution than simply updating the hardcoded version. The `AI_INSTRUCTIONS.md` file was modified to remove the static version number. The new instruction compels the AI to dynamically determine the correct protocol version by reading the `Protocol_Version` field from the authoritative `AI_System_Prompt.md` file during its own startup. This makes the initialization process self-correcting and resilient to future version changes.

2.  **Solidification (This Report):** This discovery and its resolution were documented and solidified into the CHAC knowledge base as case study M15 to ensure the reasoning behind the change is preserved.
