# Case Study Report: M39 - The Dynamic Experiment Framework

**ID:** CHAC-SD-20250717-66
**Case:** M39
**Version:** 1.0

### **1.0 What (Objective & Outcome) / Core Module**
*   **1.1 Objective:** To resolve the critical architectural limitation of a "static user profile" identified in Case Study M36, and refactor the CHAC framework to support multiple, configurable user profiles, thereby enabling its future use as an open-source, multi-user experimental platform.
*   **1.2 Outcome / Core Insights & Definitions:**
    *   **The Experiment Package Architecture:** The core outcome is a new, robust architecture centered around an `experiments/` directory. Each subdirectory within is defined as a self-contained "Experiment Package," containing all necessary configurations for a specific user or study.
    *   **Dynamic Loading Mechanism:** The static profile loading was replaced with a dynamic system. A new root-level `config.json` file now dictates which experiment package is active, and the `00_CHAC_Bootloader.md` was upgraded to v9.1 to read this file at runtime.
    *   **Clear Naming Conventions:** To enhance architectural clarity and prevent ambiguity, a set of naming conventions was established:
        *   The template directory was named `_template` to signify its non-operational, template-only status.
        *   The core profile file within each package was named `chac_profile.md` to specify its exact purpose.
*   **1.3 Outcome / Application Guides & Recommended Strategies:**
    *   **`start.sh` Guided Entrypoint:** A new `start.sh` script was created to serve as the primary, user-facing entrypoint to the framework. This script includes logic to check the user's configuration and provide clear, actionable guidance.
    *   **Multi-language Documentation:** The root `README.md` was significantly updated to explain the new architecture and user workflow. Crucially, localized versions (`README.zh.md`, `README.ja.md`) were also created to support a future international open-source audience.
    *   **`CHANGELOG.md` Update:** The `CHANGELOG.md` was updated to version `v9.1`, documenting the "Dynamic Experiment Framework" as a major architectural change.

### **2.0 Why (Rationale & Justification)**
*   This refactoring was necessary because the M36 case study concluded that the hard-coded, static user profile was the single greatest "final barrier" to a `v1.0.0` release. It made the framework fundamentally unsuitable for its intended future as a multi-user, reproducible research platform. This case study directly addresses that strategic-level debt, transforming the framework from a single-user proof-of-concept into a scalable, distributable system.

### **3.0 How (Process Summary)**
*   The case study began by identifying the "static profile" issue from the M36 report.
*   An initial plan was proposed to create a `profiles/` directory. This was quickly superseded by a more robust `experiments/` architecture after analyzing the project's long-term research plans, which revealed the need to package more than just profiles.
*   A `start.sh` script was created to provide user guidance. This script was then iteratively debugged and hardened after a series of "user" critiques revealed its initial logic was flawed and its guidance was insufficient.
*   A major sub-task involved a collaborative deep-dive into naming conventions, leading to the `_template` and `chac_profile.md` standards to resolve architectural ambiguity.
*   The core bootloader was updated to v9.1 to handle the new dynamic loading mechanism.
*   Finally, all user-facing documentation was updated to reflect the new, more complex, but far more powerful user workflow, including the creation of multi-language READMEs.

### **4.0 Analysis**
*   This case study is a powerful example of **proactive architectural refactoring**. Instead of waiting for the static profile to cause problems in a future use case, the issue was identified from a previous case study's analysis and addressed preemptively.
*   It demonstrates the critical importance of **user-centered documentation and guidance**. The creation of the `start.sh` script and the iterative refinement of the `README.md` (to include the "Why") show a mature understanding that a powerful architecture is useless if it is not understandable and usable by its target audience.
*   The evolution of the solution—from a simple `profiles` directory to the full `experiments` package architecture—highlights the CHAC pattern of starting with a simple solution and progressively adding complexity only when justified by deeper strategic requirements (in this case, the research plans).

### **4.5 Meta-Analysis of the Collaboration Process**
*   **4.5.1. Quantitative Analysis:**
    *   **Interaction Rounds:** Approximately 30-35 core interaction rounds.
    *   **AI Tool Usage:** Extensive use of `read_file`, `write_file`, `replace`, and `run_shell_command` for file system refactoring and verification.
    *   **AI Errors & Corrections:** Several errors were made, including using relative paths, making incorrect assumptions about file state after `cp` operations, and proposing unclear documentation. These were all corrected through the collaborative process.
    *   **Architect-level Interventions:** Multiple critical interventions, including the initial directive to read the research plans (which triggered the shift to the `experiments` architecture), the identification of naming ambiguities, and the repeated insistence on improving the "Why" in user documentation.
*   **4.5.2. Qualitative Analysis:**
    *   **AI Contributions:** The AI effectively executed complex, multi-step refactoring plans, proposed initial solutions for architecture and documentation, and translated high-level user feedback into concrete file modifications.
    *   **Human Architect Contributions:** The Architect consistently drove the project towards a higher level of quality and strategic alignment, refusing to accept "good enough" solutions and pushing for greater clarity, robustness, and user-friendliness in the final implementation.

### **5.0 Traceability**
*   **5.1 External Verifiability (Markers):**
    *   **Verbatim Log Start Marker:** `<CASE_STUDY_START_MARKER_CHAC-SD-20250717-66_M39_M36_Legacy_Issue_Resolution user_prompt="y">`
    *   **Verbatim Log End Marker:** `<CASE_STUDY_END_MARKER_CHAC-SD-20250717-66>`
*   **5.2 Internal Traceability (Creative Archive):**
    *   The evolution of the `README.md` file through several versions is a key traceable artifact.
    *   The `git` history of the `start.sh` script, showing its debugging and refinement, is another.

### **6.0 Appendix: Creative Process Traceability Archive**
*   **A.1 Rejected Drafts Archive:** The initial, simpler plan to create a `profiles/` directory was rejected in favor of the more scalable `experiments/` architecture. Early, less clear versions of the `README.md` were also rejected.
*   **A.2 Alternative Paths Record:** An alternative path would have been to embed the user-selection logic directly into the AI's bootloader instead of the external `start.sh` script. This was rejected to maintain a clean separation between environmental checks and core AI logic.
*   **A.3 Reserve Material & Arguments Library:** The detailed discussion about the philosophical difference between a "default" and a "_template" directory is valuable reserve material on clear communication in system design.
