# Case Study Report: Build System Repair and Intent Metadata Protocol

**ID:** CHAC-SD-20250718-66
**Case:** M51
**Version:** 1.0

### **1.0 What (Objective & Outcome) / Core Module**
*   **1.1 Objective:** To repair the outdated standalone system prompt build script (`build_prompt.sh`) and ensure its compatibility with the v11.0 protocol, while hardening it with user-centric design principles.
*   **1.2 Outcome / Core Insights & Definitions:**
    *   **The "Guardian Tool" Principle:** Core development tools should not just be functional, but should actively enforce the project's core philosophy. The final `CHAC_System_Prompt_Builder.sh` now actively aborts if a user profile is missing, thus acting as a "Guardian".
    *   **The "Beneficial Obstacle" Design Pattern:** The deliberate omission of a default `config.json` and `chac_profile.md` is a key design feature, not a bug. It forces users into a safe and intentional setup workflow.
    *   **The "Intent Metadata" Protocol:** A new protocol was proposed and implemented (in A02's README) to add a machine-readable metadata block to key documents, explicitly declaring the intent and purpose of artifacts to prevent AI misinterpretation.
*   **1.3 Outcome / Application Guides & Recommended Strategies:**
    *   A new, robust, user-centric workflow for building custom standalone prompts was created and fully documented in the `CHAC_Human_Guide.md`.
    *   The final, hardened script `CHAC_System_Prompt_Builder.sh` is now the authoritative tool for this task.

### **2.0 Why (Rationale & Justification)**
This case study was initiated by a critical system integrity failure: the only tool available to build a portable system prompt was non-functional after the v11.0 protocol refactoring. This posed a direct threat to the framework's portability and scalability. The subsequent investigation revealed deeper architectural issues related to user workflow, configuration management, and AI-readability, transforming a simple bug fix into a foundational hardening effort for the entire CHAC framework's user experience.

### **3.0 How (Process Summary)**
1.  **Initial Bug Discovery:** An attempt to build the standalone prompt failed, revealing that the build script and its config were out of sync with v11.0 protocols.
2.  **Tool Centralization:** The script was moved from its original location in A02 into the central `chac_toolkit` and renamed to `CHAC_System_Prompt_Builder.sh`.
3.  **Intent Misalignment & Discovery:** A series of dialogues about the script's purpose revealed the need for an "Intent Metadata" block, which was then added to the A02 `README.md`.
4.  **Architectural Refactoring:** Through a series of critical user interventions, the script's architecture was progressively improved:
    *   The hardcoded config path was replaced with a command-line argument.
    *   The concept of a single default config was replaced by a user-centric workflow using templates (`config.template.json`, `build_config.template.json`).
    *   The script was hardened to check for `config.json`'s existence and prevent direct use of templates.
5.  **"Guardian" Logic Implementation:** The most critical insight was that a missing user profile should be a fatal error, not a skippable warning. The script was rewritten to enforce this, aborting the build and providing clear user guidance if a profile is missing.
6.  **Full Validation:** The final, hardened script was subjected to a full validation suite, testing both the "failure path" (missing profile) and the "success path" (existing profile) to confirm its correctness.
7.  **Documentation:** The entire new workflow was fully documented in the script itself, the `CHAC_Human_Guide.md`, and the toolkit's `README.md`.

### **4.0 Analysis**
This case study is a powerful demonstration of the CHAC framework's core philosophy in action. It began as a simple, tactical bug fix ("M-Class") but evolved into a deep, strategic re-architecture of the user's primary interaction with the system's tools. The dialogue between the Architect and the AI perfectly followed the "Review & Refinement Loop," with the Architect consistently challenging the AI's assumptions, increasing the level of abstraction, and resolving systemic entropy. The final tool is a testament to this collaborative process, being not just technically functional but philosophically aligned with the project's highest principles of user-centricity and safety.

### **4.5 Meta-Analysis and Future Work**
The process of this case study revealed a number of deeper, unaddressed issues and strategic insights that are arguably more valuable than the engineering work itself. These findings have been captured in a dedicated meta-analysis report.

*   **Companion Report:** `CHAC-SD-20250718-67_meta_analysis_report.md`
*   **Content:** This report details the full backlog of technical debt and architectural improvements identified during M51, and serves as the strategic roadmap for the next case study (M52), which will focus on creating a master command-line tool to replace manual configuration.


### **5.0 Traceability**
*   **5.1 External Verifiability (Markers):**
    *   **Verbatim Log Start Marker:** `CHAC-SD-20250718-66 - 2b1b9a6a-8b9b-4b5f-8f3e-2d1c1c0a1b2c`
    *   **Verbatim Log End Marker:** `CHAC-SD-20250718-66 - 4e8b2e6d-8e1b-4f1b-8c1c-1f3a8e0c4d2d`

### **6.0 Appendix: Creative Process Traceability Archive**
*   **A.1 Rejected Drafts Archive:**
    *   The initial plan to simply fix the file paths in the original script was rejected as insufficient.
    *   A complex, `jq`-dependent design with multiple module types was proposed and then rejected as overly engineered and user-unfriendly.
    *   The idea of a "default" build config was rejected in favor of a more robust user-centric template workflow.
*   **A.2 Alternative Paths Record:**
    *   An alternative path was to keep the build script simple and require the user to manually manage the file list. This was rejected as it would increase the user's cognitive load, violating a core CHAC principle.
    *   The decision to allow the build to succeed with a warning for a missing profile was debated and ultimately rejected in favor of the "Guardian" approach of a fatal, guiding error.
