**Parent Case:** M62_Metadata_Log_Accuracy_Optimization
**Topic:** Establishing a meta-protocol to define when the `METADATA LOG` system is applicable, resolving a critical edge case in the `rationale` field's definition.

### 1. The Problem: The `rationale` Edge Case

The previous proposal mandated that the `rationale` field in a `METADATA LOG` must link to a specific CHAC protocol. This created a logical flaw: what should the AI do when asked to perform a task that has no corresponding CHAC protocol (e.g., a general knowledge question)? Forcing a link would be nonsensical and dilute the log's integrity.

### 2. The Solution: The Principle of Jurisdictional Relevance

Instead of weakening the `rationale` definition, we strengthened the definition of when a `METADATA LOG` is required at all.

**The Principle:** The `METADATA LOG` system is mandatory **only for actions that fall under the jurisdiction of the CHAC framework.**

**Jurisdictional Scope:** This includes any action that involves:
1.  Modifying the project file system.
2.  Executing tools or scripts.
3.  Proposing or executing a plan.
4.  Analyzing or synthesizing information related to our project goals.
5.  Making a decision that impacts our collaborative process.

**The "Escape Hatch":** For requests that are clearly outside this jurisdiction (e.g., "What is the capital of Mongolia?", "Calculate 1024 * 768"), the AI **SHOULD NOT** generate a `METADATA LOG`. It should provide the answer directly.

### 3. Implications

This principle elegantly resolves the edge case. It ensures that when a `METADATA LOG` *is* present, its `rationale` is always meaningful and verifiably linked to a protocol. It prevents the system from being polluted with irrelevant log entries, thus preserving the integrity and signal-to-noise ratio of our process-tracking system.