**Parent Case:** CHAC-SD-NGUxMDky-20250801
**Topic:** The Repair Plan for Core Toolkit Scripts

## 1.0 Objective

To document the detailed, two-phase plan for refactoring `chac_init_case.sh` and `chac_new_record.sh`. The goal is to fix the systemic issue of inconsistent and non-compliant file and directory naming.

## 2.0 Problem Analysis

A thorough analysis of the two scripts reveals a core architectural flaw: the lack of a shared, reliable "case_number" concept.

*   **`chac_init_case.sh`:** Fails to generate or accept a concise, protocol-compliant `case_number` (e.g., "M64"). It instead creates a long, date-based directory name and stores insufficient information in the `.chac_state` file.
*   **`chac_new_record.sh`:** In the absence of a reliable `case_number` from the state file, it resorts to a fragile "guessing" logic based on the directory name, which fails in our current use case.

## 3.0 The Repair Plan

### 3.1 Phase 1: Refactor `chac_init_case.sh`

*   **Objective:** Modify the script to create a compliant directory structure and a comprehensive `.chac_state` file.
*   **Modifications:**
    1.  **Change Signature:** The script's signature will be changed from `chac_init_case.sh "<Title>"` to `chac_init_case.sh <CaseNumber> "<Title>"`.
    2.  **Update Directory Logic:** The directory name will be constructed as `<CaseNumber>_<Title>`.
    3.  **Enhance `.chac_state` File:** The generated `.chac_state` file will be a JSON object containing:
        *   `case_id`: The `<CaseNumber>` provided (e.g., "M64").
        *   `case_name`: The full directory name.
        *   `solidification_id`: The existing unique ID.
        *   `latest_record_index`: A new field, initialized to `0`.

### 3.2 Phase 2: Refactor `chac_new_record.sh`

*   **Objective:** Modify the script to read from the `.chac_state` file, removing all guessing logic.
*   **Modifications:**
    1.  **Implement State Reading:** The script will begin by reading and parsing the `.chac_state` file from the target case directory.
    2.  **Reliable Variable Sourcing:**
        *   The `case_number` for the filename prefix will be sourced directly from the `case_id` field in the state file.
        *   The next record index will be calculated by reading `latest_record_index`, incrementing it, and using the new value.
    3.  **State Update:** After successfully creating the new record file, the script **must** write the incremented index back to the `latest_record_index` field in the `.chac_state` file. This is critical for maintaining state.
    4.  **Remove Legacy Logic:** The entire block of code dedicated to finding the "latest record" and "guessing" the prefix will be removed.

## 4.0 Expected Outcome

Upon completion of this plan, the toolkit will adhere to the following compliant workflow:
1.  `chac_init_case.sh M65 "New Study"` will create the directory `case-study/M65_New_Study` and a state file with `case_id: "M65"` and `latest_record_index: 0`.
2.  `chac_new_record.sh "case-study/M65_New_Study" "First Idea"` will read the state, create the file `M65_record_01_first_idea.md`, and update `latest_record_index` to `1`.
3.  A subsequent call will create `M65_record_02_...` and update the index to `2`.