**Parent Case:** CHAC-SD-NGUxMDky-20250801
**Topic:** The Tacit Knowledge Problem in Case Number Generation

## 1.0 Objective

To document the discovery of a critical design flaw in the CHAC toolkit: the reliance on "tacit knowledge" for generating new `CaseNumber` identifiers, and to propose a solution that makes this knowledge explicit.

## 2.0 The Discovery

Following the successful refactoring of the `chac_init_case.sh` and `chac_new_record.sh` scripts in M64, a critical question was raised: "How would a new AI instance know what `CaseNumber` to use?"

This question revealed a flaw in the system's logic:
*   The refactored `chac_init_case.sh` script now *requires* a `<CaseNumber>` (e.g., "M64", "A05") as an input.
*   However, the logic for determining the *next* available number in a series (e.g., knowing that the next M-series case after M64 is M65) exists nowhere in the explicit, machine-readable documentation or tooling.

## 3.0 Defining "Tacit Knowledge" in this Context

The knowledge of how to generate a `CaseNumber` is currently **tacit** (or implicit). It relies on:
1.  **Human Memory:** The human architect remembers the last used number.
2.  **Contextual Inference:** An AI could theoretically `ls` the `case-study/` directory and manually parse the directory names to find the latest number.

## 4.0 The Risks of Tacit Knowledge

This reliance on tacit knowledge poses significant risks to the system's integrity and scalability:

*   **Cognitive Burden:** It places an unnecessary cognitive load on the human architect to track administrative details.
*   **Brittleness and Inconsistency:** It makes the AI's behavior dependent on its ability to correctly parse file system conventions, which could change over time. A slight change in directory naming could break the AI's inference logic.
*   **Onboarding Friction:** A new AI instance, without the context of our current dialogue, would be unable to perform a core task (initiating a case study) without significant, and possibly flawed, guesswork.
*   **Violation of Core Principles:** This design violates the **Dependency Abstraction** principle. The AI's core logic should depend on stable, explicit tools, not on fragile inferences about the state of the file system.

## 5.0 The Solution: Making Knowledge Explicit

The solution is to create a new, dedicated tool whose sole responsibility is to be the **single source of truth** for the next available `CaseNumber`.

*   **Proposed Tool:** `chac_next_case_id.sh`
*   **Functionality:** This script will accept a class (`M` or `A`) as an argument, scan the `case-study/` directory, and output the next valid `CaseNumber` in that series (e.g., "M65").

By creating this tool, we transform the tacit knowledge into an explicit, machine-executable rule, thereby increasing the system's robustness and reducing the cognitive load on its users (both human and AI).