# Final Refactoring Plan for Reporting and State-Management

## 1. Objective
To fix the missing marker issue in case study reports and to harden the entire reporting and state-management process against future errors.

## 2. Core Architectural Decisions
- **Single Source of Truth**: The `.chac_state` file in each case directory is the sole authoritative source for all case metadata.
- **YAML Front Matter**: Final reports will use YAML Front Matter for all machine-readable metadata (IDs, markers), separating it cleanly from the human-written prose content.
- **Automated Report Assembly**: The final report will be assembled by a reliable script, not by the AI's procedural memory. This moves logic from an error-prone process to a verifiable tool.
- **Abstract Protocol**: The `CHAC_Case_Study_Protocol.md` will define abstract rules (the "why"), while project-specific conventions will handle implementation details (the "how"), ensuring protocol portability.

## 3. Report Structure Refactoring
- **Section 3 (Process Summary)**: Will be enhanced to include explicit, context-aware references to the atomic records that document the successful path.
- **Section 5 (Traceability)**: Section 5.1 (Markers) will be entirely replaced by the YAML Front Matter. Section 5.2 will be renamed `Summary of Rejected & Alternative Paths` and will contain a pure text summary of the Appendix, with no hard links.
- **Section 6 (Appendix)**: Purpose remains unchanged - to archive valuable but unused intellectual paths.

## 4. Implementation Plan
1.  **Modify `chac_init_case.sh`**: Add logic to write the `start_marker_uuid` to the `.chac_state` file.
2.  **Modify `chac_conclude_case.sh`**: Add logic to write the `end_marker_uuid` to the `.chac_state` file.
3.  **Create `report_template.md`**: A new file containing the boilerplate structure of a report with placeholders for metadata and content.
4.  **Create `chac_generate_report.sh`**: A new script that reads `.chac_state`, takes AI-generated content as input, and uses the template to assemble the final, complete report file.
5.  **Update `CHAC_Case_Study_Protocol.md`**: Refactor the protocol to reflect the new, automated report generation process and the updated report structure.
6.  **End-to-End Verification**: After implementation, create a new test case to validate the entire new workflow from initialization to final report generation.