# Atomic Record: M67-04 - Methodology: Core vs. Secondary Definitions

- **Parent Case:** M67_Bootloader_Context_Failure_Analysis
- **Topic:** Establishing a formal classification for types of knowledge within the CHAC framework.
- **Record ID:** M67_record_04

---

### 1. The Need for Classification

The "Context Saturation" problem necessitates a formal distinction between different classes of definitional knowledge. This allows us to apply different, appropriate access strategies to each, rather than treating all knowledge as a monolithic block.

### 2. Classification Schema

We hereby establish two classes of definitions:

#### 2.1 Core Definitions

*   **Definition:** Information that is an **absolute prerequisite for basic, frequent, and global operations**. The AI must have this information "in memory" and highly salient at the start of any session to function correctly.
*   **Characteristics:** Operationally critical, high-frequency use, globally applicable.
*   **Access Strategy: Pre-emptive Loading ("Memory").** Core Definitions must be loaded into the AI's context with maximum Signal-to-Noise Ratio. The `00a_CHAC_Critical_Definitions.md` file is the designated location and mechanism for this strategy.
*   **Analogy:** The operating system kernel.

#### 2.2 Secondary Definitions

*   **Definition:** Rich background knowledge, philosophical principles, and specific, context-dependent rules that are valuable for deep analysis but not required for every operation.
*   **Characteristics:** Explanatory, low-frequency or context-specific use.
*   **Access Strategy: On-Demand Lookup ("Search").** The AI is not expected to have this information constantly "in memory." Instead, it is expected to know *that this information exists* and *where to find it* using its tools (e.g., `read_file` on `CHAC_Glossary.md`). The M67 recovery, where the AI successfully read the glossary to find the definition, serves as the proof-of-concept for this strategy's viability.
*   **Analogy:** The operating system's API documentation or help files.

### 3. Architectural Implication

This classification formalizes a key design principle: **We are consciously designing for two different information access patterns.** We are moving away from a simplistic "provide all context" model to a more sophisticated model where we actively manage whether information should be "remembered" (pre-loaded) or "searchable" (on-demand). This architectural choice is a direct and necessary compensation for the AI's inherent cognitive limitations.
