# M69 Record 01: P-1.1 Proactive Template-Based Command Construction Protocol

**Parent Case:** M69_Analyze_Tool_Execution_Cancellation_Error
**Topic:** Definition of a new core AI operational protocol to prevent command construction errors.
**Status:** Proposed

---

### 1.0 Core Principle

To enhance reliability and prevent structural errors in command execution, the AI's primary method for running tools defined in `chac_toolkit/scripts/manifest.json` shall shift from "manual command construction" to "template-based instantiation".

### 2.0 Protocol Definition

For any user directive that maps to a script in `manifest.json`, the AI MUST follow this strict procedure:

1.  **Template Extraction:** The AI MUST treat the `example_invocation` field from the manifest entry as a literal, machine-readable template.
2.  **Variable Identification:** The AI MUST parse the template to identify all variables, denoted by the `<...>` syntax.
3.  **Dependency Analysis & State-Aware Variable Acquisition:** The AI MUST analyze the list of required variables. If acquiring a variable's value requires a prior action (e.g., acquiring `<CaseNumber>` requires running `chac_next_case_id.sh`), the AI MUST perform that action first.
4.  **Safe Instantiation:** The AI MUST NOT construct the final command "by hand". Instead, it MUST perform a direct, literal substitution of the identified variables into the extracted template string.
5.  **Execution:** Only the fully instantiated and validated command may be proposed for execution.

### 3.0 Scope and Limitations

This protocol is powerful but has a strictly defined operational scope.

*   **3.1 In-Scope:** This protocol ONLY applies to routine tasks whose command structure is simple enough to be accurately represented by a static string template in `manifest.json`.

*   **3.2 Out-of-Scope (Path B Trigger):** Any task requiring complex, conditional command logic (e.g., dynamic flags based on context) is explicitly out of scope. Such tasks MUST be handled via the "Path B" (Bespoke Task) framework, requiring a detailed, human-approved execution plan.

### 4.0 Risk Analysis & Mitigation

*   **4.1 Risk: Flawed Template (Garbage In, Garbage Out)**
    *   **Description:** The protocol's integrity is wholly dependent on the accuracy of the templates in `manifest.json`.
    *   **Mitigation:**
        *   **Human Responsibility:** The Architect is responsible for ensuring the 100% accuracy of all `example_invocation` templates.
        *   **Future Work (CI):** A CI check could be implemented to perform dry-runs on manifest templates to validate them automatically.

*   **4.2 Risk: AI Capability Drift**
    *   **Description:** The protocol assumes the AI possesses sufficient capabilities for template parsing and stateful variable mapping.
    *   **Mitigation:** These required capabilities should be explicitly documented and considered when evaluating or upgrading the core AI model.

---