
# M74 Verbatim Log Transformer - JSON Output Schema

This document defines the structure of the JSON file generated by the `transform_log.py` script.

## Root Object

The root of the JSON object contains metadata about the session and the two main components: the epilogue and the conversation.

| Key | Type | Description |
|---|---|---|
| `log_filename` | String | The name of the original verbatim log file. |
| `session_id` | String | The session identifier, extracted from the log filename (e.g., "20250820-213459"). |
| `epilogue` | Object \| Null | A structured representation of the session summary epilogue. See [Epilogue Object](#epilogue-object) for details. Can be `null` if no epilogue is found. |
| `conversation` | Array | An array of turn objects, representing the dialogue between the user and the AI. See [Turn Object](#turn-object) for details. |

---

## Epilogue Object

The `epilogue` object contains the parsed data from the summary box at the end of a log file.

| Key | Type | Description |
|---|---|---|
| `raw` | String | The complete, raw text of the epilogue block. |
| `tool_calls_total` | String \| Null | Total number of tool calls made. |
| `tool_calls_successful` | String \| Null | Number of successful tool calls. |
| `tool_calls_failed` | String \| Null | Number of failed tool calls. |
| `success_rate` | String \| Null | The percentage success rate of tool calls. |
| `user_agreement_rate` | String \| Null | The percentage user agreement rate for tool calls. |
| `wall_time` | String \| Null | Total duration of the session. |
| `agent_active_time` | String \| Null | Time the agent was actively working. |
| `api_time` | String \| Null | Time spent on API calls. |
| `tool_time` | String \| Null | Time spent on tool execution. |
| `model_usage` | Array | An array of model usage objects, one for each model used. See [Model Usage Object](#model-usage-object) for details. |

### Model Usage Object

Each object in the `model_usage` array details the token consumption for a specific model.

| Key | Type | Description |
|---|---|---|
| `model_name` | String | The name of the model (e.g., "gemini-1.5-pro-001"). |
| `requests` | Integer | The number of requests made to this model. |
| `input_tokens` | Integer | The total number of input tokens sent to this model. |
| `output_tokens` | Integer | The total number of output tokens received from this model. |

---

## Turn Object

Each object in the `conversation` array is a turn. It has a consistent structure to identify the speaker.

| Key | Type | Description |
|---|---|---|
| `speaker` | String | Identifies who is speaking. Either "user" or "ai". |
| `content` | String | The textual content of the turn. |

### Example Turn Objects

**User Turn:**
```json
{
  "speaker": "user",
  "content": "This is an example of user input."
}
```

**AI Turn:**
```json
{
  "speaker": "ai",
  "content": "This is an example of AI output."
}
```
