
# M74 Verbatim Log Transformer - Script Usage Guide

This document provides instructions on how to use the `transform_log.py` script to convert Gemini CLI verbatim logs into structured JSON files.

## Description

The `transform_log.py` script parses a text-based verbatim log file. It identifies and separates user and AI turns, extracts the detailed session summary (epilogue), and outputs the structured data as a JSON object.

This structured format is ideal for programmatic analysis, data mining, and archiving of conversational sessions.

## Requirements

- Python 3.x

## Usage

The script is executed from the command line and accepts one required argument and one optional argument.

### Syntax

```bash
python transform_log.py <input_file> [options]
```

### Arguments

-   **`input_file`** (Required): The path to the input verbatim log file. This is the raw `.txt` file generated by the Gemini CLI.

### Options

-   **`-o, --output_file <output_file>`** (Optional): The path to the output JSON file. If this option is not provided, the script will print the JSON output directly to the standard output (stdout).

## Examples

### Example 1: Writing to a JSON file

This is the most common use case. It reads a log file and writes the structured output to a new JSON file.

```bash
python transform_log.py ../../.ai-cli-log/gemini-20250820-213459.txt -o gemini-20250820-213459.json
```

**Expected Output (in terminal):**
```
Successfully wrote structured log to gemini-20250820-213459.json
```
A new file, `gemini-20250820-213459.json`, will be created in the current directory.

### Example 2: Printing to Standard Output

This is useful for quickly inspecting the output or for piping the JSON data to another command-line tool (like `jq`).

```bash
python transform_log.py ../../.ai-cli-log/gemini-20250820-213459.txt
```

**Expected Output (in terminal):**
The full, formatted JSON object will be printed to the console.

```json
{
  "log_filename": "gemini-20250820-213459.txt",
  "session_id": "20250820-213459",
  "epilogue": {
    // ... epilogue data ...
  },
  "conversation": [
    // ... conversation turns ...
  ]
}
```

## Error Handling

- If the `input_file` is not found, the script will print an error message to stderr and exit with a status code of 1.
- If the script encounters an error while reading the input file or writing the output, it will print an error message to stderr and exit.
