#!/bin/bash
#
# M76 - Batch Transformation Script (v2 - Hardcoded Paths)
#
# This script automates the process of converting raw .txt logs from
# .ai-cli-log/ into structured .json files using the M74 transform tool.
# Version 2 uses hardcoded paths from the project root for reliability.

# --- Configuration ---
# Paths are now relative to the project root where the script is executed from.
TRANSFORM_SCRIPT_PATH="case-study/M74_Structured_Transformation_of_Verbatim_Logs/transform_log.py"
LOG_SOURCE_DIR=".ai-cli-log"
OUTPUT_DIR="case-study/M76_Quantitative_Study_of_the_CHAC_Workbench/preprocessed_logs"

# --- Pre-flight Checks ---
if [ ! -f "$TRANSFORM_SCRIPT_PATH" ]; then
    echo "Error: Transform script not found at $TRANSFORM_SCRIPT_PATH"
    exit 1
fi

if [ ! -d "$LOG_SOURCE_DIR" ]; then
    echo "Error: Log source directory not found at $LOG_SOURCE_DIR"
    exit 1
fi

if [ ! -d "$OUTPUT_DIR" ]; then
    echo "Error: Output directory not found at $OUTPUT_DIR"
    exit 1
fi

echo "Starting batch transformation (v2)..."
echo "Source: $LOG_SOURCE_DIR"
echo "Destination: $OUTPUT_DIR"
echo "---------------------------------"

# --- Main Loop ---
file_count=0
for logfile in $(find "$LOG_SOURCE_DIR" -name "*.txt"); do
    filename=$(basename "$logfile" .txt)
    output_json="$OUTPUT_DIR/${filename}.json"
    
    echo "Processing: $logfile -> $output_json"
    
    # Execute the python script
    python3 "$TRANSFORM_SCRIPT_PATH" "$logfile" -o "$output_json"
    
    file_count=$((file_count + 1))
done

echo "---------------------------------"
echo "Batch transformation complete. Processed $file_count files."