# M76 - Record 02: Data Dictionary for Quantitative Metrics

**Parent Case:** M76_Quantitative_Study_of_the_CHAC_Workbench
**Topic:** Data Dictionary for Quantitative Metrics

---

## 1.0 Objective

This document provides a clear and unambiguous definition for each metric extracted and calculated in the `01_extract_data.py` and `02_generate_reports.py` scripts. It serves as the "source of truth" for interpreting the quantitative analysis reports.

---

## 2.0 Metric Definitions

### 2.1 Core Interaction Metrics

*   **`turns`**
    *   **Definition:** The total number of individual conversational exchanges in a log file. Every element in the `conversation` array of the JSON log (both `speaker: user` and `speaker: ai`) counts as one turn.
    *   **Purpose:** Measures the raw volume of interaction.

*   **`user_intent_sequences`**
    *   **Definition:** The total number of times the user initiated an interaction. It is calculated by counting the number of `speaker: user` turns in a log file.
    *   **Purpose:** A more meaningful measure of interaction volume that reflects how many distinct requests or initiatives the user took.

### 2.2 Tool & System Performance Metrics

*   **`tool_calls_total`**
    *   **Definition:** The total number of times the AI attempted to use a tool, extracted from the `epilogue`.
    *   **Purpose:** Measures the frequency of AI tool usage.

*   **`tool_calls_successful`**
    *   **Definition:** The number of tool calls that completed successfully, extracted from the `epilogue`.
    *   **Purpose:** Measures the reliability of AI tool usage.

*   **`Tool_Success_Rate` (Derived)**
    *   **Definition:** `tool_calls_successful / tool_calls_total`.
    *   **Purpose:** A key indicator of the AI's operational efficacy and the framework's robustness.

### 2.3 Cognitive Cost Metrics (Model Usage)

*   **`total_requests`**
    *   **Definition:** The total number of API requests made to the language model during the session, summed from the `model_usage` section of the `epilogue`.
    *   **Purpose:** Measures the computational cost in terms of API calls.

*   **`total_input_tokens`**
    *   **Definition:** The total number of tokens sent *to* the model.
    *   **Purpose:** Measures the amount of context and information required by the AI to perform its tasks.

*   **`total_output_tokens`**
    *   **Definition:** The total number of tokens received *from* the model.
    *   **Purpose:** Measures the volume of the AI's generated content.

*   **`Tokens_per_Sequence` (Derived)**
    *   **Definition:** `(total_input_tokens + total_output_tokens) / user_intent_sequences`.
    *   **Purpose:** A powerful proxy metric for the "cognitive cost" of a user's intent. A high number may indicate a complex task or an inefficient workflow.

### 2.4 Framework Adherence & Dynamics Metrics

*   **`metadata_log_count`**
    *   **Definition:** The total number of `METADATA LOG` blocks found in the raw `.txt` log file.
    *   **Purpose:** A direct measure of the AI's adherence to Protocol 8 and a key metric for verifying the accuracy of the data extraction process itself.

*   **`events`**
    *   **Definition:** A list of all values extracted from the `* event:` field within `METADATA LOG` blocks.
    *   **Purpose:** Categorizes the types of actions and occurrences within a session, allowing for analysis of interaction patterns.

*   **`active_functions`**
    *   **Definition:** A list of all values extracted from the `* active_function:` field within `METADATA LOG` blocks.
    *   **Purpose:** Categorizes the AI's operational role or "mindset" during an action, allowing for analysis of the collaborative dynamics.