# M76 - Record 03: Future Work - Dynamic Token Analysis

**Parent Case:** M76_Quantitative_Study_of_the_CHAC_Workbench
**Topic:** Specification for a future "Dynamic Token Analysis" study.

---

## 1.0 Objective

The static token analysis performed in this case study provides a baseline understanding of the cognitive load of the CHAC toolkit's components. However, a **dynamic analysis** is required to answer a more critical question: **"How is this cognitive load actually distributed and utilized during real-world interactions?"**

This future work aims to quantify the "cognitive economy" of the CHAC framework in practice.

## 2.0 Core Research Questions

This analysis would allow us to answer questions such as:

1.  **Component Hotspots:** Which toolkit files (`.md`, `.sh`) are most frequently included in the AI's context window? Are there core protocols that are read in almost every turn, versus others that are rarely used?
2.  **Cognitive Cost of Tasks:** Do certain types of tasks (e.g., "code refactoring" vs. "philosophical analysis") consistently require a larger token context to be loaded?
3.  **Impact of Refactoring:** Can we quantitatively prove that architectural changes (e.g., splitting a large protocol into smaller, more modular ones) actually reduce the average token count per interaction?
4.  **Context Efficiency:** What percentage of the AI's context window, on average, is composed of static toolkit files versus the dynamic conversation history?

## 3.0 Proposed Technical Plan

### 3.1. Data Source

The primary data source would be the raw, verbatim log files located in the `.ai-cli-log/` directory. These files contain the complete record of every piece of information (prompts, file contents, tool outputs) that constitutes the AI's context at each turn.

### 3.2. Methodology

A new, sophisticated parsing script would be required. Its logic would be as follows:

1.  **Iterate Through Logs:** The script would process each log file chronologically.
2.  **Identify AI Turns:** It would identify each point in the dialogue where the AI is about to generate a response.
3.  **Reconstruct Context:** For each AI turn, the script must "look backwards" and reconstruct the exact context window that was fed to the AI. This involves:
    *   Identifying the base system prompt.
    *   Identifying all files whose contents were explicitly read and injected (e.g., via `ReadFile` or `ReadManyFiles` tool calls).
    *   Including the preceding conversational history.
4.  **Attribute Tokens:** The script would then use `tiktoken` to calculate the token count for each component of this reconstructed context and attribute it to its source (e.g., `04_CHAC_System_Prompt.md: 1089 tokens`, `Conversation History: 512 tokens`).
5.  **Aggregate Data:** The script would aggregate this data across all turns in all log files to produce a final dataset.

### 3.3. Expected Output

-   **`table_6_dynamic_token_usage.csv`**: A table showing each toolkit component and its key dynamic metrics (e.g., `total_times_referenced`, `total_tokens_contributed`, `avg_token_contribution_per_turn`).
-   **New Visualizations**: Charts showing the "Top 10 Most Referenced Toolkit Files" or the "Average Context Composition by Task Type".

## 4.0 Value Proposition

This analysis would provide an unprecedented, quantitative view into the "cognitive mechanics" of a sophisticated AI agent framework. It would move beyond simply analyzing the AI's output (its behavior) to analyzing its **input** (its cognitive environment), providing a much deeper and more rigorous understanding of how and why it works.
