# M76: Quantitative Study of the CHAC Workbench

This case study contains the data, scripts, and analysis for a quantitative study of the CHAC Workbench's performance and evolution.

To re-run the full analysis pipeline, execute the following command from the repository root:
```bash
bash case-study/M76_Quantitative_Study_of_the_CHAC_Workbench/start_analysis.sh
```

## Directory Structure

-   `./`: Contains the core, numbered scripts (`00_*` to `08_*`) that form the data analysis pipeline, the master `start_analysis.sh` script, and the original `plan.md`.
-   `_dev_archive/`: Contains scripts and notebooks used during the development and debugging of the pipeline. These are not required for execution but are kept for historical context.
-   `intermediate_data/`: Contains the raw, per-log metrics extracted by `03_extract_metrics.py`. This is a machine-generated directory.
-   `output/`: Contains the final, human-readable analysis results, including summary tables (.csv) and visualizations (.png). This is a machine-generated directory.
-   `output_verbose_log/`: Contains the detailed, line-by-line log of the last full run of the `start_analysis.sh` script. This is a machine-generated directory.
-   `preprocessed_logs/`: Contains the structured JSON versions of the raw text logs from the `.ai-cli-log` directory, transformed by `00_batch_transform.sh`. This is a machine-generated directory.
