
import json
import re

# --- Regex Pattern ---
METADATA_BLOCK_RE = re.compile(r"---+\s*\n(?:\s*\*?\s*METADATA LOG\s*\*?\s*\n)?((?:\s*\*\s*.*\n)+)\s*---+", re.IGNORECASE)

# --- Test ---
print("--- Testing Regex Against JSON-Loaded Content ---")

with open('case-study/M76_Quantitative_Study_of_the_CHAC_Workbench/preprocessed_logs/gemini-20250718-193714.json', 'r') as f:
    data = json.load(f)

# The exact content string from the conversation
content_from_json = data['conversation'][10]['content']

match = METADATA_BLOCK_RE.search(content_from_json)

if match:
    print("SUCCESS: Regex matched the content from the JSON file.")
    print("Captured Block:", match.group(1))
else:
    print("FAIL: Regex did not match the content from the JSON file.")
    print("--- Content ---")
    print(repr(content_from_json)) # Print with escaped characters to see hidden issues
    print("--- End Content ---")
