import re
from pathlib import Path

# --- Configuration ---
RAW_LOG_PATH = Path('.ai-cli-log/gemini-20250822-021723.txt')

# --- Regex ---
METADATA_BLOCK_RE = re.compile(r"---+\s*\n(?:[ \t]*METADATA LOG\s*\n)?((?:\s*\*.*\n?)+)\s*---+", re.IGNORECASE)

# --- Debug Execution ---
def main():
    print(f"--- Debugging Regex Match Count on {RAW_LOG_PATH.name} ---")
    
    if not RAW_LOG_PATH.is_file():
        print("Error: Raw log file not found.")
        return

    raw_content = RAW_LOG_PATH.read_text(encoding='utf-8')
    
    matches = METADATA_BLOCK_RE.finditer(raw_content)
    
    count = 0
    for match in matches:
        count += 1
        # print(f"Found match #{count}:\n---\n{match.group(1).strip()}\n---")

    print(f"\nFinal Count from finditer loop: {count}")

if __name__ == "__main__":
    main()
