#!/bin/bash
#
# M76 - Log to Commit Mapper
#
# This script finds the initial commit hash for each raw log file
# in the .ai-cli-log directory.

# --- Configuration ---
LOG_SOURCE_DIR=".ai-cli-log"
OUTPUT_CSV="case-study/M76_Quantitative_Study_of_the_CHAC_Workbench/output/log_to_commit_map.csv"

echo "Starting log to commit mapping..."
echo "Log Source: $LOG_SOURCE_DIR"
echo "---------------------------------"

# Create CSV header
echo "log_file,commit_hash" > "$OUTPUT_CSV"

# --- Main Loop ---
file_count=0
for logfile in $(find "$LOG_SOURCE_DIR" -name "*.txt"); do
    commit_hash=$(git log --diff-filter=A --pretty=format:%H -- "$logfile")
    
    if [ -n "$commit_hash" ]; then
        # There might be multiple commits if the file was moved/renamed, take the last one (oldest)
        oldest_commit=$(echo "$commit_hash" | tail -n 1)
        echo "Mapping: $logfile -> $oldest_commit"
        echo "$logfile,$oldest_commit" >> "$OUTPUT_CSV"
        file_count=$((file_count + 1))
    else
        echo "Warning: Could not find initial commit for $logfile"
    fi
done

echo "---------------------------------"
echo "Mapping complete. Mapped $file_count files."
echo "Map saved to: $OUTPUT_CSV"
