# M76 Analysis Output: Data Dictionary

This directory contains the final, human-readable outputs of the M76 quantitative analysis pipeline.

---

## Tier 1: Scale & Scope Analysis

These files provide a high-level overview of the scale of the CHAC project.

### `table_1_scope_and_scale.csv`
-   **Intent:** To provide the core metrics for establishing the study's credibility.
-   **Content:** A simple key-value table of the project's macro-statistics.
-   **Data Schema:**
    -   `Metric`: The name of the metric (e.g., "Total Case Studies (Analyzed)").
    -   `Value`: The calculated value for that metric.

### `table_1a_interaction_breakdown.csv`
-   **Intent:** To show the distribution of work across different case studies.
-   **Content:** A list of all analyzed case studies, sorted by the number of user interactions.
-   **Data Schema:**
    -   `Case_Study_ID`: The unique identifier for the case study (e.g., "M42_The_CHAC_Doctrine").
    -   `User_Intent_Sequences`: The number of times the user initiated a conversational turn.
    -   `Total_Turns`: The total number of back-and-forth exchanges (both user and AI).

---

## Tier 2: Dynamics & Patterns Analysis

These files analyze the nature of the human-AI collaboration.

### `table_2_dynamics_and_patterns.csv`
-   **Intent:** To provide proxy metrics for the "cost" and "efficacy" of the collaboration in each case study.
-   **Content:** A list of all analyzed case studies with their calculated tool success rates and token usage.
-   **Data Schema:**
    -   `Case_Study_ID`: The unique identifier for the case study.
    -   `Tool_Success_Rate`: The percentage of tool calls that executed successfully (`successful_calls / total_calls`).
    -   `Tokens_per_Sequence`: The average number of total tokens (input + output) consumed per user intent sequence. A proxy for cognitive cost.

### `table_2a_function_distribution.csv`
-   **Intent:** To quantify which roles the AI embodied during the collaboration.
-   **Content:** An aggregate count of how many times each `active_function` (e.g., "Guardian", "Cognitive Buffer") was declared in a `METADATA LOG`.
-   **Data Schema:**
    -   `Active_Function`: The name of the CHAC function.
    -   `Count`: The total number of times that function was activated across all logs.

### `table_2b_event_distribution.csv`
-   **Intent:** To quantify the types of actions and events that occurred during the collaboration.
-   **Content:** An aggregate count of how many times each `event` type (e.g., "informedProceeding", "selfCorrection") was declared in a `METADATA LOG`.
-   **Data Schema:**
    -   `Event_Type`: The name of the event.
    -   `Count`: The total number of times that event occurred across all logs.

---

## Tier 3: Evolution & Efficacy Analysis

These files explore the relationship between the framework's evolution and the AI's performance.

### `table_3_evolution_data.csv`
-   **Intent:** To provide the raw time-series data for the final visualization.
-   **Content:** A chronological list of individual log sessions, ordered by their associated M-class case study number.
-   **Data Schema:**
    -   `case_num`: The numeric part of the associated M-class case study (used for sorting).
    -   `log_name`: The filename of the verbatim log.
    -   `success_rate`: The tool success rate for that specific session.
    -   `success_rate_ma`: The moving average of the tool success rate.

## Tier 3 & 4: Evolution, Scale, and Visualization

These files explore the relationship between the framework's evolution and the AI's performance, as well as the scale of the components.

### `table_3_evolution_data.csv`
-   **Intent:** To provide the raw time-series data for the evolution visualization.
-   **Content:** A chronological list of individual log sessions, ordered by their associated M-class case study number.
-   **Data Schema:** `case_num`, `log_name`, `success_rate`, `success_rate_ma`.

### `table_4_static_token_counts.csv`
-   **Intent:** To provide a static measure of the "cognitive footprint" of the active (non-archived) CHAC toolkit.
-   **Content:** A list of all AI-relevant files in the `chac_toolkit` and their corresponding token counts.
-   **Data Schema:** `File_Path`, `Token_Count`.

### `table_5_growth_analysis.csv`
-   **Intent:** To provide the raw data for visualizing the project's growth over time.
-   **Content:** A list of every commit in the repository's history.
-   **Data Schema:** `commit_hash`, `timestamp`, `max_case_num`, `total_project_tokens`, `total_toolkit_tokens`.

---

## Visualizations

### `figure_1_evolution_and_efficacy.png`
-   **Intent:** To visually test the core hypothesis: "Does protocol hardening lead to improved AI operational reliability?"
-   **Content:** A time-series line chart showing the moving average of the AI's tool success rate over time. Vertical dashed lines are overlaid to indicate the points in the timeline where major "protocol hardening events" occurred.

### `figure_2_interaction_breakdown.png`
-   **Intent:** To visually identify the most significant case studies in terms of interaction volume.
-   **Content:** A horizontal bar chart showing the Top 20 case studies ranked by the number of user intent sequences.

### `figure_3_dynamics_scatter.png`
-   **Intent:** To explore the relationship between the cognitive cost and operational efficacy of the collaboration.
-   **Content:** A scatter plot where each point is a case study, plotting its `Tokens_per_Sequence` (x-axis) against its `Tool_Success_Rate` (y-axis).

### `figure_4_function_distribution.png`
-   **Intent:** To provide a clear, visual breakdown of the AI's primary roles.
-   **Content:** A horizontal bar chart showing the activation frequency of the Top 10 AI `active_function`s.

### `figure_5_token_treemap.png`
-   **Intent:** To visualize the "cognitive architecture" of the active `chac_toolkit` by showing the relative token weight of its components.
-   **Content:** A treemap where the area of each rectangle is proportional to the static token count of a file. Files are colored by their semantic purpose (e.g., Core Identity, Operational Protocols).

### `figure_6_growth_analysis.png`
-   **Intent:** To visualize the growth of the project's "cognitive scale" over its research history.
-   **Content:** A line chart with a log-scale Y-axis showing the growth of the total token count for both the entire project and the `chac_toolkit`, plotted against research milestones (M-series case study numbers).
