# README: start_analysis.sh

This script is the master execution entrypoint for the M76 Quantitative Analysis pipeline.

## Purpose

This script automates the entire, end-to-end process of:
1.  Preprocessing raw logs.
2.  Mapping logs to case studies using Git history.
3.  Extracting dozens of quantitative metrics from each log.
4.  Verifying the accuracy of the extraction.
5.  Aggregating the metrics and generating final summary tables (Tier 1 & 2).
6.  Analyzing the static token count of the active toolkit components.
7.  Analyzing the historical growth of the repository's token scale over time.
8.  Generating a comprehensive set of visualizations for all analyses (Tier 3 & 4).

## How to Run

Execute the script from the **root of the chac-workbench repository**:
```bash
bash case-study/M76_Quantitative_Study_of_the_CHAC_Workbench/start_analysis.sh
```

## Output

-   **Verbose Log**: A complete, line-by-line log of the entire run is saved to `case-study/M76_Quantitative_Study_of_the_CHAC_Workbench/output_verbose_log/`.
-   **Final Reports**: The final, clean data tables and visualizations are saved to `case-study/M76_Quantitative_Study_of_the_CHAC_Workbench/output/`.
