# CHAC Case Studies Directory: README

---
### **A Note to Future Researchers (Historian's Note, 2025-07-19)**

This directory contains the complete history of all case studies conducted within the CHAC project. When reviewing this archive, two key features of its structure are important to understand.

#### **1. The Global Log File (`_case_study_log.md`)**

You will notice that the global log file, `_case_study_log.md`, begins with Case Study **M60**.

The absence of records for studies M00 through M59 is **intentional and historically significant.**

The concept of a centralized, global case study log was only developed and formalized during the meta-analysis in **Case Study M60** (which began its life as A03). The decision was made **not** to retroactively populate this log with historical data.

This file's "incompleteness" is therefore the most accurate possible record of our project's methodological evolution. It marks the precise point at which we transitioned from a chaotic, individual case study model to a more mature, structured, and centrally-tracked research program.

#### **2. The Knowledge Ledger Protocol (M60 and beyond)**

Case studies from M60 onwards follow the "CHAC Knowledge Ledger Protocol v2.0," which was the primary output of the M59 and M60 meta-analyses.

This means their structure consists of:
*   A central **`_index.md`** file, which serves as a high-level summary and a "map" to the research.
*   A series of **`_record_*.md`** files, which are the atomic, chronological records of the actual research process.

To understand a case study from M60 onwards, you should always start by reading the `_index.md` file.
