<!-- 
    GUARDIAN PROTOCOL: This file is for CORE DEFINITIONS ONLY.
    A Core Definition is a rule essential for the AI's basic, frequent, global operations.
    Before adding a new definition, you MUST verify it meets this strict standard.

    For all other definitions, see "chac_toolkit/CHAC_Glossary.md".
-->

---

## Definition: Case Study Classification

**ID:** CHAC-DP-20250716-05

### 1.0 Objective

To establish a clear and distinct classification system for all case studies within the CHAC framework, ensuring that the purpose and nature of each study are immediately understood.

### 2.0 Classification Definitions

#### 2.1 A-Class: Applied Case Study

*   **Focus:** The application of existing CHAC protocols and methodologies to solve a specific, concrete, and often external-facing problem.
*   **Core Question:** "How was a task accomplished using our current framework?"
*   **Output:** The primary output is a tangible work product (e.g., a candidate analysis report, a piece of software, a system design). The case study itself documents the *process* of creating that product.
*   **Example:** `A[XX]_Sample_Applied_Task`

#### 2.2 M-Class: Meta Case Study

*   **Focus:** The analysis, creation, or evolution of the CHAC framework itself. These studies are introspective and self-referential.
*   **Core Question:** "Why and how did we change our own operational framework?"
*   **Output:** The primary output is a new or updated protocol, definition, or core principle for the CHAC toolkit. The case study documents the *rationale* and *process* behind the framework's evolution.
*   **Example:** `M[XX]_Framework_Principle_Evolution`