> **Architect's Note on Meta-Protocol Design:**
> When a case study's objective is the creation or refinement of a core SOP or protocol, it should be governed by the more specific procedure outlined in `chac_toolkit/CHAC_SOP_System_Prompt_Design.md`, which provides a detailed framework for such meta-design tasks. This current document remains the general protocol for all other standard case studies.

> **Architect's Note on the Solidified Document Generation Protocol (SDGP):**
>
> This protocol integrates the principles of the Solidified Document Generation Protocol (SDGP).
>
> *   **Objective:** The SDGP's objective is to transform exploratory dialogue into a structured, reusable knowledge asset.
> *   **Guiding Principles:** Its guiding principles are: 1) **Distillation** (retaining core findings), 2) **Decoupling** (separating tools from arguments), and 3) **Reusability** (designing for future use).
> *   **Implementation:** Within this document, the SDGP is not a separate process but is implemented directly as the mandatory structure for the final report generated in Phase 2.

**Document ID:** CHAC-AP-20250716-17
**Document Type:** A-Class (Applied)
**Title:** Integrated Case Study Solidification Protocol
**Version:** v10.1
**Status:** Active

#### **1.0 Objective**

To establish a complete, end-to-end, and rigorous methodology for the creation of all A-Class and M-Class case studies. This protocol ensures that all case studies produce a final report that is a **traceable, verifiable, and reusable knowledge asset**.

#### **2.0 Guiding Principles**

*   **Process Integrity:** The entire workflow, from initiation to completion, must be followed to ensure a complete and auditable record.
*   **External Verifiability:** The final report must be verifiably linked to the raw, external verbatim log via non-negotiable Marker IDs.
*   **Product Value:** The final report is not merely a process record, but a high-value intellectual product. Its creation is guided by:
    *   **Distillation:** Retain only core findings, filtering out procedural noise.
    *   **Decoupling:** Separate neutral "tools" from specific "arguments."
    *   **Reusability:** Design the final report as a foundational module callable by future projects.

#### **3.0 Protocol Phases**

**Phase 1: Initiation and Scoping (Clarified)**
*   **Objective:** To correctly classify, identify, and structure the case study from the outset.
*   **Procedure:**
    1.  The AI MUST use the `chac_next_case_id.sh` script to determine the next available Case ID.
    2.  The AI MUST then use the `chac_init_case.sh` script to correctly initialize the case study.
    3.  The AI MUST understand that these scripts are the **single source of truth** for generating the case directory, the `.chac_state` file, and the `start_marker_uuid`. The scripts will automatically record the UUID in both the `.chac_state` file (for machine use) and the verbatim log (for human verification).

**Phase 2: Analysis and Content Generation**
*   **Objective:** For the AI to perform the core analytical work of the case study.
*   **Procedure:**
    1.  The AI's primary role is to generate the **analytical content** for the report. This includes the Objective, Rationale, Process Summary, Analysis, and Appendix sections.
    2.  The AI will save this complete body of text to a temporary file in preparation for the final assembly step.

**Phase 3: Guided Report Completion**
*   **Objective:** To finalize the case study and complete the final report using a guided, two-step, script-assisted workflow. This process is designed to minimize AI cognitive load and ensure structural consistency.
*   **Procedure:**
    1.  **Step A: Script-Assisted Draft Generation**
        a.  The AI MUST first call the `chac_conclude_case.sh` script to finalize the case and record the end marker. **To determine the correct usage and parameters for this script, the AI MUST consult the `chac_toolkit/scripts/manifest.json` file.**
        b.  Immediately following this, the AI MUST call the `chac_generate_report.sh` script, again consulting `manifest.json` for its usage.
        c.  The AI MUST understand that this script's function is to create a **report draft** (`..._report_draft.md`). This draft is generated by combining the machine-readable data from `.chac_state` with the structure and **inline AI instructions** from the `report_template.md` file.
    2.  **Step B: AI-Driven Content Completion**
        a.  The AI's primary cognitive task is to read the newly created report draft.
        b.  The AI MUST treat the HTML-style comments (`<!-- AI_INSTRUCTION: ... -->`) within the draft as its direct, contextual instructions for each section.
        c.  Following these inline instructions, the AI will replace the simple placeholders (e.g., `{{PROCESS_SUMMARY_CONTENT}}`) with its full analytical and written content.
        d.  Upon completion, the AI will overwrite the draft file, thereby creating the final, complete report.

Context-ID: #solid-protocol_9b1e
