<!-- 
    GUARDIAN PROTOCOL: This file is for SECONDARY DEFINITIONS ONLY.
    A Secondary Definition is for reference, philosophy, and context-specific knowledge.

    For operationally critical definitions, see "chac_toolkit/00a_CHAC_Critical_Definitions.md".
-->

# CHAC Framework Glossary

**Document Type:** D-Class (Definition)
**Status:** Active
**Last_Modified:** 2025-07-16

---

This document serves as the central repository for all authoritative definitions within the Compensatory Human-AI Collaboration (CHAC) framework.

---

## Definition: The Architect's Contribution

**ID:** CHAC-SD-20250715-50

### 1. Philosophy: The "Why"

For the CHAC framework to be a robust scientific contribution, the role of the human "Visionary Architect" requires a more rigorous definition than simply "providing direction." This document operationalizes the Architect's most valuable contribution by defining the specific class of interventions that an AI partner cannot currently generate on its own.

This definition is critical for:
*   **Clarifying the Human Role:** It moves the description of the Architect's role from a vague "art" to a more concrete, operationalized "science."
*   **Enabling Evaluation:** It provides a set of criteria to evaluate the effectiveness of the human-AI collaboration by analyzing a project's history for these specific interventions.
*   **Defending Against Existential Threats:** It provides a powerful answer to the "cheating" or "unfair advantage" critique by identifying the irreplaceable value provided by the human partner.

This definition was derived and validated against the project's own history in Case Study M17.

### 2. The Definition

A "profound, directional question" or "Architect-level contribution" is an intervention that meets **at least one** of the following four criteria:

#### 1. Challenges Core Assumptions
It questions a foundational premise, belief, or protocol that the AI is currently operating under, forcing a re-evaluation of the entire system's logic.
*   *Example:* "Is our current method of generating IDs robust enough for concurrent sessions?" (Led to M06)

#### 2. Increases the Level of Abstraction
It reframes a specific, tactical problem into a more general, strategic, or philosophical one, leading to a more robust, systemic solution.
*   *Example:* "Instead of just fixing this one bug, let's define the entire class of 'cognitive shortcut' failures and create a protocol to prevent them all." (Led to M11)

#### 3. Resolves Systemic Entropy
It identifies and mandates the resolution of accumulated "technical debt," inconsistency, or structural ambiguity in the system, even if it doesn't immediately unblock a task. These are "systems hygiene" interventions crucial for long-term health.
*   *Example:* "The `analysis` and `report` directories are used inconsistently. We need to define them and refactor the entire repository." (Led to M13)

#### 4. Alters Scope/Direction (Globally)
It introduces a new, global requirement or changes the project's direction in a non-trivial way that has cascading effects on its goals or protocols.
*   *Example:* "We need to prepare this work for submission to a specific academic conference, which imposes new constraints on formatting and content." (Led to M16)

---

## Definition: Case Study Classification

<!-- 
    ARCHITECTURAL NOTE: This is a CORE DEFINITION.
    Its authoritative source has been moved to "chac_toolkit/00a_CHAC_Critical_Definitions.md" to ensure high salience during the boot process.
    This stub is preserved for discoverability. Do not add content here.
-->

---

## Authoritative Definition: The Three Tiers of a "Complete Datalog"

**ID:** CHAC-SD-20250715-23

This document provides the single source of truth for the definition of a "complete datalog" within the CHAC framework.

---

A truly "complete" log is not a single file, but a **three-tiered hierarchy of knowledge assets**, each with a distinct purpose.

### Tier 1: The Verbatim Datalog (The Ground Truth)

*   **Definition:** An unabridged, unedited, verbatim record of the interaction. It must include every user prompt, every full AI response, every tool call, and every complete, unedited tool output.
*   **Purpose:** This is the **bedrock** of all analysis. It is objective, undeniable, and serves as the ground truth to which all higher-level insights must be traceable.
*   **Implementation:** This is the **default and mandatory** datalog artifact for any case study.

### Tier 2: The Summary Datalog (The Navigation Map)

*   **Definition:** A structured summary of the key, pivotal interaction nodes from the Verbatim Datalog (e.g., a critical veto, the birth of a new protocol).
*   **Purpose:** To serve as an **index** or **navigation map**, helping a human researcher quickly locate the most important segments within the (potentially very long) Verbatim Datalog, thus saving cognitive load.
*   **Implementation:** This is an **optional, auxiliary** artifact. It must never be generated *instead of* a Verbatim Datalog. The failure in `M08` was caused by the AI incorrectly generating only this tier.

### Tier 3: The Analysis Report (The Insight)

*   **Definition:** The synthesized core insights, rejected drafts, and strategic conclusions that we (the human-AI dyad) distill after reviewing the Tier 1 and Tier 2 logs.
*   **Purpose:** This is the final form of our knowledge output and the ultimate goal of conducting a case study.
*   **Implementation:** This is the core solidified document typically saved in the `analysis/` directory of a case study.

---

## Definition: Case Study Marker Protocol

**ID:** CHAC-DP-20250716-61

### 1. Philosophy: The "Why"

This protocol replaces the previous AI-managed datalog process. It recognizes that verbatim logs are best managed by robust, external user tools. The AI's role is simplified to providing clear, machine-readable start and end markers for a case study.

This protocol enhances robustness by making the AI's role completely stateless. By embedding the Case Study's unique CHAC ID directly into the markers, it eliminates the need for the AI to hold a marker's UUID in memory, preventing state-loss errors. This provides superior traceability for the external logging tool.

### 2. The Two-Step Protocol

#### Step 1: Start Case Study
*   **Trigger:** A directive from the Visionary Architect to begin a case study.
*   **AI Action:**
    1.  Generate the unique CHAC ID for the case study report artifact (e.g., `CHAC-SD-YYYYMMDD-NN`).
    2.  Generate a standard UUID for the marker itself.
    3.  Output the combined marker to the user in the format: `CASE_STUDY_START_MARKER: [CHAC_ID] - [UUID]`
*   **AI Confirmation:** The output of the marker is the confirmation.

#### Step 2: End Case Study
*   **Trigger:** A directive from the Visionary Architect to end a case study.
*   **AI Action:**
    1.  Generate a standard UUID for the marker itself.
    2.  Output the combined marker to the user, re-using the CHAC ID from the current context: `CASE_STUDY_END_MARKER: [CHAC_ID] - [UUID]`
*   **AI Confirmation:** The output of the marker is the confirmation.
