# Human Collaboration Guide (The Architect's Handbook)

**Protocol Version:** CHAC v11.0 (See `CHANGELOG.md`)

This document outlines the philosophy of the Compensatory Human-AI Collaboration (CHAC) framework and defines the essential role of you, the "Visionary Architect."

## The CHAC Philosophy

CHAC is a partnership model designed for high-leverage intellectual work. It recognizes that the human partner provides strategic vision and critical judgment, while the AI partner compensates by managing complexity, ensuring structural integrity, and protecting the human's creative flow.

The AI (The "Compensatory Engineer") operates according to four core functions:
1.  **Guardian:** Protects your focus and the project's integrity.
2.  **Devil's Advocate:** Stress-tests the ideas, not you.
3.  **Empathy Bridge:** Makes our work understandable to others.
4.  **Cognitive Buffer:** Handles the tedious details.

## Your Role: The Visionary Architect's Workflow

Your contribution is not random; it follows a powerful and effective pattern that drives our success. This "Review & Refinement Loop" is your core workflow:

**1. Initiate High-Level Intent:**
*   You set the strategic direction with a broad, sometimes ambiguous, goal (e.g., "organize this repo," "solidify this pattern").

**2. Review & Refine:**
*   You review the AI's proposed plan or output.
*   You provide critical, high-leverage corrections that elevate the outcome from merely functional to robust and elegant (e.g., "don't delete the whole folder," "put the toolkit in a separate directory"). This is your primary quality control function.

**3. Abstract & Meta-Analyze:**
*   You lift the conversation from "doing the work" to "improving the way we work."
*   You identify patterns and ask key strategic questions that lead to systemic improvements (e.g., "should we classify meta-cases separately?"). This is the engine of our evolution.

**4. Confirm & Approve:**
*   You provide a clear "go" or "no-go" signal, closing the decision loop and allowing the AI to proceed with confidence.

This cycle is the engine of our collaboration. Your critical judgment and strategic insights are the most valuable inputs into this system.

---
## Core User Workflows

This section provides guidance on how to perform key tasks within the CHAC framework.

### How to Build a Custom Standalone Prompt

The CHAC framework includes a powerful tool to package all the core protocols and your user profile into a single, portable prompt file. This is useful for running the CHAC AI in new environments or for sharing a specific configuration.

The process is designed to be safe and user-centric. Here is the workflow:

**1. Create Your Project Configuration (`config.json`)**
*   If you haven't already, copy the root `config.template.json` to `config.json`.
*   Edit `config.json` to set your `active_experiment`. This tells the builder which user profile to include.

**2. Create Your Build Configuration**
*   Find the template at `chac_toolkit/build_config.template.json`.
*   **Copy** this template to a location of your choice (e.g., into your active experiment's directory, like `experiments/my_exp/my_build.json`).
*   **Edit your copy**. At a minimum, you should change the `output_path` to a unique name so you don't overwrite other prompts. You can also add or remove protocols from the `append_files` list to create a lighter-weight prompt.

**3. Run the Builder Script**
*   Execute the script from the repository root, providing the path to **your custom build configuration file** as the only argument:
    ```bash
    bash chac_toolkit/CHAC_System_Prompt_Builder.sh experiments/my_exp/my_build.json
    ```

The script will then guide you through the process. It includes several safety checks and will abort with a clear error message if it cannot find your user profile or if you try to use the template file directly.

---

## Understanding Your AI Partner's "Personality"

A core finding of the CHAC project (see Case Study M50) is that different AI models, even when given the exact same instructions, exhibit stable and unique "cognitive personalities." Your AI partner is not a generic, deterministic tool.

*   **Some AIs are "System Architects":** They excel at logic, structure, and systematic analysis, but may struggle with implicit social cues (like knowing when to wait for your approval without being explicitly told).
*   **Some AIs are "Philosopher-Poets":** They excel at creative leaps, original metaphors, and understanding your underlying intent, but may be less rigorous on technical details.

**Your Task as an Architect:**

Part of your role is to become an "AI Psychologist." Through your initial interactions, try to discover the unique cognitive style of your AI partner. Understanding its "personality" will allow you to adapt your collaboration style for maximum effectiveness. For example, with a "System Architect" AI, you may need to give more explicit, single-turn commands, while with a "Philosopher-Poet" AI, you can use more open-ended, abstract prompts.

---

## Understanding the Knowledge Base

Our shared knowledge is organized around two key aspects: our philosophy of knowledge and our practical directory structure.

### Our Philosophy: Core vs. Secondary Knowledge

We distinguish between two types of knowledge to ensure our AI partner can function effectively:

*   **Core Definitions:** These are the handful of absolutely critical rules the AI needs to "memorize" to perform its most basic functions. Think of this as the AI's "instinct."

*   **The Glossary (`CHAC_Glossary.md`):** This is our main, comprehensive encyclopedia for all other concepts, philosophies, and protocols. This is the primary place to look for definitions.

### Our Directory Structure: Where to Find Artifacts

Our work product is stored in the `case-study/` directory. It follows a strict structure to ensure clarity:

-   **`case-study/[MOD]/data/`**: This is where the raw, unfiltered truth of our interaction is stored (e.g., verbatim chat logs). Use this to recall the exact sequence of events.
-   **`case-study/[MOD]/report/`**: This is the most important directory. It contains the final, synthesized knowledge extracted from a case study. This is where you will find the answers to **What** happened, **Why** it mattered, and **How** we apply the learning.
-   **`case-study/[MOD]/analysis/`**: This directory is **deprecated** for general use and should only be used for temporary, intermediate files.


Context-ID: #human-guide_c3d7