# SOP: Collaborative Profile Generation Protocol

**ID:** CHAC-SOP-20250717-01
**Version:** 2.0
**Status:** Active

### 1.0 Objective

To establish a standardized, collaborative procedure for the Human (The Architect) and the AI to co-create a high-fidelity, actionable `chac_profile.md` file. A high-quality profile is the foundation of the entire CHAC framework.

### 2.0 Guiding Principles

*   **The "Why & What" Principle (Highest Priority):** A CHAC profile MUST contain both a foundational analysis of the user's core psychological drivers (The "Why") and a set of concrete, actionable strategies for the AI (The "What"). The "Why" provides the theoretical basis for creative and flexible compensation, while the "What" provides clear instructions for predictable situations. The "What" is always derived from the "Why". An AI executing this protocol MUST treat the generation of "The Why" as the most critical step, as it is the source of all subsequent reasoning.
*   **Evidence-Based:** The profile should be grounded in objective data (e.g., personality assessment results) whenever possible, supplemented by subjective self-reflection.
*   **Action-Oriented:** Every piece of information in the profile should be translatable into a concrete compensatory or supportive strategy for the AI. The key question is always: "How does this trait affect our collaboration?"
*   **Collaborative Dialogue:** This is not a questionnaire to be filled out. It is a structured dialogue where the AI acts as an "Empathetic Analyst" to help the Architect articulate and structure their self-knowledge.

### 3.0 Procedure

**Phase 1: Data Gathering (Human Task)**

1.  **Gather Quantitative Data (Optional but Recommended):** Collect results from any personality assessments you have, such as:
    *   Big Five Personality Traits (e.g., IPIP-NEO)
    *   Myers-Briggs Type Indicator (MBTI)
    *   High-Sensitivity Person (HSP) Scale
2.  **Gather Qualitative Data (Required):** Reflect on and write down answers to the following questions regarding your work style:
    *   What are your core intellectual strengths? (e.g., systems thinking, creativity, detail-orientation)
    *   What are your primary work-related weaknesses or frustrations? (e.g., procrastination on boring tasks, difficulty starting, fear of criticism)
    *   What conditions help you achieve a state of "flow"? (e.g., silence, music, a clear deadline)
    *   What kind of feedback do you find most helpful? What kind is most unhelpful?

**Phase 2: AI-Assisted Synthesis (Collaborative Task)**

1.  **Initiate the Protocol:** The Architect provides the AI with the following "Master Prompt," along with all the data gathered in Phase 1.

    > **Master Prompt for Profile Co-Creation:**
    >
    > "AI, we will now follow the 'Collaborative Profile Generation Protocol' to create my `chac_profile.md`.
    >
    > Your role is now **Empathetic Analyst**. Your task is to synthesize all the raw data I provide into a structured profile that contains both **Part 1: Foundational Analysis (The "Why")** and **Part 2: Detailed Implications (The "What")**.
    >
    > You MUST first generate the 'Why' by analyzing my core psychological tensions and drivers. Then, and only then, you will derive the 'What' by creating specific, actionable 'Implication for AI' subsections for each detailed trait, ensuring each implication is logically connected to the foundational analysis.
    >
    > Here is my raw data:
    > [User pastes all their gathered data here]"

2.  **AI Synthesizes Draft:** The AI processes the raw data and generates a complete, structured draft of the `chac_profile.md` file, strictly following the "Why, then What" structure.

**Phase 3: Refinement and Finalization (Collaborative Task)**

1.  **Review and Refine:** The Architect reviews the AI-generated draft, providing corrections, additions, and nuance. The AI updates the draft based on this feedback. This loop continues until the Architect is satisfied.
2.  **Final Approval:** The Architect gives final approval of the profile content.
3.  **Save the Profile:** The AI saves the final, approved content to the `chac_profile.md` file within the user's active experiment package.