# SOP: CHAC Data Security & Anonymization

**ID:** CHAC-SOP-M52-20250718
**Version:** 1.0
**Status:** Active

### 1.0 Objective

To establish a strict, non-negotiable Standard Operating Procedure (SOP) for the classification, handling, and anonymization of all data within the CHAC framework, with the primary goal of protecting the Architect's psychological privacy.

### 2.0 Guiding Principles

*   **The Principle of "Psychological Safety First":** The Architect's psychological safety and privacy is the highest priority, overriding all other considerations, including technical convenience or even intellectual fidelity if a conflict arises.
*   **The Principle of "Data as a Liability":** All data, especially data describing the Architect's internal state, is to be treated as a potential liability. It should only be collected, stored, and used for the explicit, user-approved purpose of improving the compensatory function of the AI.
*   **The Principle of "Separation of Concerns":** Portable system configurations MUST be strictly separated from private user data at all stages of the workflow.
*   **The Principle of "Anonymized Directives":** Instructions for the AI derived from private data must be anonymized to remove any explanatory link to the underlying private data.

### 3.0 Data Classification Levels

This SOP establishes three formal levels of data classification. All files and artifacts within the CHAC framework must be handled according to their classification level.

*   **Level 3 (L3): Strictly Private**
    *   **Definition:** Any data that describes the Architect's internal psychological landscape. This includes, but is not limited to, `chac_profile.md` files, raw notes, and any dialogue containing self-reflection.
    *   **Handling Protocol:**
        *   MUST reside only in the `experiments/` directory structure.
        *   MUST NEVER be included, copied, or bundled into any artifact intended for distribution.
        *   MUST be treated as the highest class of PII.

*   **Level 2 (L2): Redactable for Distribution**
    *   **Definition:** Artifacts that synthesize insights from L3 data but are intended for wider, controlled sharing (e.g., Case Study Reports).
    *   **Handling Protocol:**
        *   Before distribution, MUST undergo the rigorous redaction process defined in Section 4.0 of this SOP.

*   **Level 1 (L1): Publicly Safe**
    *   **Definition:** Artifacts that are purely procedural, philosophical, or technical and contain no user-specific data (e.g., Core Protocols, this SOP itself).
    *   **Handling Protocol:**
        *   These files are safe for public distribution.

### 4.0 Redaction Standard Operating Procedure

This procedure defines the mandatory steps for transforming an L2 artifact from an internal draft into a distributable version.

**4.1 Definition of Personal Information (PII) in the CHAC Context**
For the purposes of this framework, PII is defined not just as data that can identify a person, but as **any data that describes a person's internal psychological landscape.** This includes:
*   **Direct PII:** Quantitative scores from personality assessments.
*   **Qualitative PII:** Qualitative interpretations of traits (e.g., "High," "Low").
*   **Inferential PII:** Any text, including instructions for the AI, from which a reader could reasonably infer a specific psychological trait or vulnerability of the user (e.g., "Because the user has low interpersonal awareness...").

**4.2 The Redaction Workflow**
1.  **Duplicate the Artifact:** Never edit the original L2 artifact. Always work on a copy intended for distribution.
2.  **Redact Direct & Qualitative PII:** Systematically replace all quantitative scores and qualitative labels in tables or text with `[REDACTED]`.
3.  **Anonymize Inferential PII:** This is the most critical step. Review all text, especially AI directives or analyses derived from the user profile. Rewrite these sections to be purely operational, removing any "because..." clauses that link the directive to a personal trait.
    *   **Example (Incorrect - Leaks PII):** *"Guardian: The AI must guard the Architect's physical environment because they are sensitive to sensory overload."*
    *   **Example (Correct - Anonymized):** *"Guardian: A standing operational directive is to minimize environmental distractions."*
4.  **Final Review:** The Architect MUST perform a final review of the redacted document to confirm it meets the standard of "Psychological Safety First."

### 5.0 Tooling Implications

This SOP mandates the following evolution of the framework's core tools, to be implemented in Case Study M52 and beyond.

*   **`CHAC_System_Prompt_Builder.sh`**:
    *   The script's "Guardian" logic, which aborts the build if a `chac_profile.md` is missing, is confirmed as correct and essential.
    *   A new build target, `--level L1`, MUST be added. When this flag is used, the script will execute a build that **strictly excludes** Stage 4 (the dynamic inclusion of the user profile). This will be used to generate a truly portable, publicly safe version of the system prompt.

*   **`chac_cli.sh` (Future M52 deliverable)**:
    *   This tool will be responsible for the **runtime injection** of the user profile.
    *   The standard workflow will be:
        1. The user starts the AI via `chac_cli.sh start`.
        2. The CLI first loads the L1 (Publicly Safe) standalone prompt.
        3. The CLI then reads the user's active L3 `chac_profile.md`.
        4. The CLI injects the profile content into the AI's context *in memory*, without ever creating a bundled L2 artifact on disk.
    *   This architecture enforces the "Separation of Concerns" principle at a fundamental level.