# SOP: Modular System Prompt Builder (v1.0)

**Document ID:** CHAC-SOP-A02-FINAL
**Version:** 1.0
**Status:** Active
**Author:** Visionary Architect & Compensatory Engineer AI
**Scope:** This document outlines the Standard Operating Procedure (SOP) for dynamically building a high-fidelity, optimized, and standalone system prompt for a CHAC-compliant AI. This SOP supersedes all previous "distillation" or "static concatenation" approaches.

---

## 1.0 Core Philosophy: Build, Don't Distill

The fundamental principle of this SOP is that a CHAC AI's instruction set is too complex and interdependent to be reliably "distilled" or "refactored" into a single static document. Doing so inevitably introduces information loss and logical conflicts.

Therefore, the only high-fidelity method for creating a portable prompt is to **build** it dynamically, module by module, based on a specific configuration, using the original, unmodified protocol files as the source of truth.

---

## 2.0 The Build Process

The build process is governed by a `build_config.json` file and executed by a build script or an AI agent following this SOP.

### **Step 2.1: Define the Build Configuration**

Create a `build_config.json` file to declare the intended composition of the final prompt.

*   **`build_target`**: A descriptive name for the build (e.g., "Full_Case_Study_AI", "Lightweight_Q&A_Bot").
*   **`core_protocols_source`**: The path to the boot manifest file that lists the core, non-negotiable protocols.
    *   *Default:* `chac_toolkit/01_CHAC_Boot_Manifest.md`
*   **`optional_modules`**: A list of optional, configurable modules to include in the build. These typically represent specific workflows or advanced capabilities.
    *   *Example:* `["ProtocolOrchestrator", "ReportGenerator"]`

### **Step 2.2: Execute the Modular Build**

**Action:** The builder agent reads the `build_config.json` and the `core_protocols_source` manifest.

1.  **Initialize Prompt Content**: Start with an empty string or buffer.

2.  **Generate and Prepend Dynamic HostRequirements**:
    *   Analyze the full list of modules to be included (core + optional).
    *   Dynamically determine the complete set of `Host.*` capabilities required by these modules.
    *   Generate the `HostRequirements` module and prepend it to the prompt content. This ensures the contract with the runtime environment is explicit and accurate for the current build.

3.  **Concatenate Core Protocols**:
    *   Read the file paths from the `core_protocols_source` manifest.
    *   For each file path:
        *   Read the entire, unmodified content of the source file.
        *   Append a separator (e.g., `--- START OF FILE: [filepath] ---`) to the prompt content.
        *   Append the source file's content.
    *   This ensures the AI's core "personality" and "philosophy" are always included with 100% fidelity.

4.  **Concatenate Optional Modules**:
    *   For each module listed in the `optional_modules` array of the build config:
        *   Locate the corresponding source file (e.g., `chac_toolkit/protocols/CHAC_Protocol_Orchestrator.md`).
        *   Append a separator and the file's full content to the prompt.

### **Step 2.3: Output the Final Product**

**Action:** Save the fully concatenated prompt content to a new file.

*   **Filename Convention:** `standalone_prompt_[build_target]_[timestamp].md`
*   **Example:** `standalone_prompt_Full_Case_Study_AI_20250718.md`

---

## 3.0 Validation

The generated standalone prompt must be validated in a clean, new session to ensure its functional integrity. The test plan should be tailored to the modules included in the build.

---

## 4.0 Conclusion of A02 Case Study

This SOP represents the final, authoritative conclusion of the A02 Case Study. The core finding is that a **dynamic, modular build process** is the only viable method for producing a high-fidelity and adaptable standalone prompt for a complex, protocol-driven AI like CHAC.
