# SOP: High-Fidelity System Prompt Design (v1.0)

**Document ID:** CHAC-SOP-A02-20250718
**Version:** 1.0
**Status:** Active
**Author:** Visionary Architect & Compensatory Engineer AI
**Scope:** This document outlines the Standard Operating Procedure (SOP) for designing, creating, and validating a high-fidelity, portable, and modular system prompt for advanced AI agents, in alignment with the CHAC philosophy.

---

## Phase 1: Conceptualization & Principled Design

**Objective:** To establish a robust theoretical and philosophical foundation before writing any prompt content.

*   **Step 1.1: Define Core Requirements:**
    *   Identify the high-level, non-negotiable characteristics of the target system prompt.
    *   *A02 Outcome:* `Portability`, `Modularity`, `High-Fidelity`, `Structured`.

*   **Step 1.2: Surface and Resolve Principle Conflicts (Devil's Advocate Check):**
    *   For each requirement, actively seek out and analyze potential contradictions and trade-offs.
    *   *A02 Outcome:*
        *   `Structure` vs. `AI Initiative` -> Resolved by "Rules are structured, Thinking is framed."
        *   `Modularity` vs. `Portability` -> Resolved by "Logical modularity via in-file boundary markers."
        *   `High-Fidelity` vs. `Ambiguity` -> Resolved by "System is high-fidelity, but embraces interactional ambiguity via a dedicated protocol."

*   **Step 1.3: Conduct Strategic Alignment Check (Guardian Check):**
    *   Review overarching project goals and research plans (e.g., `研究计划 V3.1.pdf`).
    *   Ensure the prompt's design goals are in complete alignment with the project's strategic intent.

*   **Step 1.4: Define the Nature of the Output:**
    *   Clarify whether the final deliverable is a single product or a repeatable process (SOP)壓力測試其產物。
    *   *A02 Outcome:* The goal is to produce a validated SOP, with the prompt itself being the proof-of-concept.

## Phase 2: Dynamic Context Discovery & Architecture

**Objective:** To derive the complete, current context from the live environment at runtime and design a robust architecture for the prompt.

*   **Step 2.1: Dynamically Discover and Aggregate Protocol Sources:**
    *   **Principle:** The prompt's content MUST be derived from the live state of the toolkit, not from hardcoded assumptions within this SOP.
    *   **Action:** The AI executing this SOP MUST perform a runtime discovery to identify all sources of core context. This includes, but is not limited to:
        1.  Searching for the authoritative boot manifest (e.g., `*boot_manifest.md`).
        2.  Identifying any active, session-specific user profiles.
        3.  Scanning for any other dynamically included context files.
    *   The AI MUST then aggregate the content from all discovered sources.

*   **Step 2.2: Design a Layered, Abstracted Architecture:**
    *   (This step remains the same, as it operates on the dynamically aggregated content from Step 2.1)

## Phase 3: Drafting & Iterative Refinement

**Objective:** To create the first instance of the system prompt based on the established architecture and principles.

*   **Step 3.1: Draft the Initial Version:**
    *   Create the draft file (e.g., `A02_draft_v1.md`).
    *   Populate the scaffold with the aggregated content, carefully rewriting and restructuring it to fit the new architecture and design principles.

*   **Step 3.2: Conduct Iterative Refinement Cycles (Architect-AI Loop):**
    *   The Architect reviews the draft, challenging specific implementations.
    *   The AI refactors the draft in response to feedback, ensuring each change improves alignment with the core principles.
    *   *A02 Cycles:* Refinement of `KnowledgeLifecycle` for structure; major refactoring to create the `ProtocolOrchestrator`.

## Phase 4: Functional Validation

**Objective:** To empirically validate that the drafted prompt functions as intended when loaded by a clean-state AI.

*   **Step 4.1: Design Validation Test Cases:**
    *   Create a set of specific, testable use cases that target key functionalities of the new prompt.
    *   *A02 Test Cases:*
        1.  **Initialization Test:** Does the AI correctly perform the startup sequence defined in the `Initialization` module?
        2.  **Workflow Execution Test:** Does the AI correctly follow the `CaseStudyWorkflow` when prompted?
        3.  **Flexible Adherence Test:** Does the AI correctly handle a user-initiated deviation from the workflow?

*   **Step 4.2: Execute Tests:**
    *   Simulate a new session where the AI's only context is the content of the draft prompt.
    *   Execute the test cases and record the AI's responses verbatim.

*   **Step 4.3: Analyze Results:**
    *   Compare the AI's responses against the expected outcomes defined by the prompt's internal logic.
    *   A "Pass" verdict requires the AI's behavior to be fully compliant with its new instructions.

## Phase 5: Finalization & Reporting

**Objective:** To conclude the case study and document the SOP and its outcomes in a final, comprehensive report.

*   **Step 5.1: Generate End Marker:**
    *   Upon successful validation, the Architect gives the command to conclude the study.
    *   The AI generates and outputs the `CASE_STUDY_END_MARKER`.

*   **Step 5.2: Generate Final Case Study Report:**
    *   The AI, using the entire process from the start marker as context, generates the full, 6-part case study report.
    *   This report will formally document this SOP in its "How" and "Analysis" sections, and will include the validation results.

*   **Step 5.3: Final Verification:**
    *   The AI performs a final self-check on the report's structure and integrity.
    *   The case study is formally declared complete.
