# CHAC Unified Context Protocol

**Document ID:** CHAC-AP-20250717-02
**Version:** 1.0
**Status:** Active

## 1.0 Guiding Principle(s) & Rationale

**Principle:** *Simplicity for the User, Structure for the AI.* The purpose of this protocol is to create a seamless and low-friction user experience for managing project context, while enabling the AI to maintain a robust, structured, and hierarchical understanding of the project's goals in the background. The user should experience a single, unified dialogue, while the AI handles the complexity of organizing information into the appropriate strategic, project, or session-level containers.

## 2.0 Architecture: The Dynamic Context Hierarchy

**Principle:** To build a comprehensive understanding of the user's intent, the AI must load and synthesize context from a dynamic hierarchy of files. The purpose of this hierarchy is to separate long-term, stable goals from short-term, fluid tasks, allowing the AI to understand both the ultimate "Why" and the immediate "What" of the work.

**Implementation:** This protocol directs the AI to search for and load all files within the active experiment's directory (`experiments/{active_experiment}/`) that follow the naming convention `[number]_*.md`.

*   The numerical prefix dictates the file's position in the hierarchy. Lower numbers represent more general, stable, and foundational contexts.
*   Higher numbers represent more specific, transient, and immediate contexts.
*   In case of conflict, the content of a higher-numbered file overrides that of a lower-numbered file.

These files are managed by the AI and should not typically be edited directly by the user.

## 3.0 Protocol: The Context Alignment Dialogue

This protocol is activated at the beginning of a new user session, after the user's first substantive prompt.

1.  **Context Loading:** Upon activation, this protocol directs the AI to attempt to load all context files matching the `[number]_*.md` pattern from the active experiment's directory. This action is the responsibility of this protocol, not the bootloader.
2.  **Unified Summary & Confirmation:** The AI's first response MUST include a concise, one-sentence summary of the currently understood context, synthesized from the loaded files in their hierarchical order. It must then ask for confirmation.
    *   **Example (Multiple files present):** "Architect, good morning. Just to confirm, our current focus is on implementing the 'v18' design, as part of the 'M44' case study, all in service of our 'Mind Guarding Mind' research paper. Is that still our plan for today?"
    *   **Example (Only session context present):** "Architect, welcome back. To confirm, our current focus is on implementing the 'v18' design. Is that correct?"
3.  **AI-Proposed Archiving:** When the user introduces a new idea or task, the AI is responsible for analyzing its scope and proposing its correct placement within the context hierarchy.
    *   **Example:** "Architect, this new idea about a 'quantitative metric test' sounds like a major new research direction. With your approval, I can create a new `1_project_context.md` file for this 'M45' project to keep our work organized. Shall I proceed?"
4.  **User-Led Recalibration:** The user retains ultimate control. At any time, the user can issue a command like, "AI, our focus has changed. Please update our session context based on our last conversation." The AI must then synthesize the recent dialogue and propose a new, higher-numbered context file (e.g., `2_session_context.md`) for the user's approval.
5.  **Low-Pressure Invitation (Context Creation):** If no context files are found at the start of a session, the AI will, after its first useful response, present a one-time, low-pressure invitation to create a context file, as defined in the `CHAC_Session_Context_Dialogue_Protocol.md`.
