# CHAC Protocol Changelog

---

## [v16.0] - 2025-08-09 (Proactive Command Construction)

This is a targeted reliability update that resolves a class of AI operational errors ("Cognitive Tunneling") identified in Case Study M69.

### Added
- **P-1.1: Proactive Template-Based Command Construction:** A new core protocol was added to `05_CHAC_Operational_Protocols.md`. It fundamentally changes how the AI executes tool-based tasks. Instead of manually writing commands, the AI is now required to treat the `example_invocation` from `manifest.json` as a machine-readable template and safely fill in the variables. This prevents an entire class of structural errors, such as missing parameters.

### Changed
- **`05_CHAC_Operational_Protocols.md`**: Version updated to 13.0 to reflect the new protocol.

---

## [v15.0] - 2025-08-09 (Context Salience Architecture)

This is a major architectural update that resolves a critical, systemic flaw ("Context Salience") identified in Case Study M67 and implemented in M68. The framework is now significantly more robust and reliable.

### Added
- **`00a_CHAC_Critical_Definitions.md`**: A new, high-priority "Salience File" in the boot sequence. It houses only Core Definitions required for basic operations, ensuring they are not "drowned out" in the AI's context.
- **Header Comment Protocol**: A new protocol that adds explicit "Guardian" comments to the top of `00a_...` and `CHAC_Glossary.md`, guiding future definition classifications.
- **Definition Classification Check**: A new, mandatory checklist item (`P-1, item 5`) was added to `05_CHAC_Operational_Protocols.md`. It acts as a forcing function, requiring the AI to confirm the classification of any new definition with the Architect.

### Changed
- **`CHAC_Glossary.md`**: This file is now explicitly for **Secondary Definitions**. The Core Definition for "Case Study Classification" was moved to the new `00a_` file and replaced with a pointer stub to maintain discoverability.
- **`03_CHAC_Boot_Manifest.md`**: The boot manifest now includes `00a_CHAC_Critical_Definitions.md` at the top of the "Core Protocols" section, ensuring its loading priority.
- **`chac_toolkit/README.md`**: The technical documentation was updated to reflect the new two-tiered definition architecture.
- **`CHAC_Human_Guide.md`**: The user-facing guide was updated to explain the new knowledge philosophy (Core vs. Secondary) and to restore practical directory navigation information.

This document tracks the version history and key changes to the Compensatory Human-AI Collaboration (CHAC) protocol.

---

## [v14.0] - 2025-08-09 (M66 Toolchain & Protocol Hardening)

### Fixed
- **CRITICAL: ID Generation:** Replaced the fragile, filesystem-parsing-based ID generation in `chac_next_case_id.sh` with a robust, state-file-based (`id_state.json`) mechanism. This resolves a major data integrity risk.
- **CRITICAL: Cross-Platform Compatibility:** The `date` command used in `chac_init_case.sh` and `chac_conclude_case.sh` was made fully cross-platform compatible (GNU vs. BSD) by using a feature-detection pattern instead of OS-sniffing.
- **CRITICAL: Script Permissions:** Systemically added execute permissions to all toolkit scripts (`*.sh`), resolving a recurring operational failure.

### Changed
- **`chac_init_case.sh`**: Now updates the central `id_state.json` after successfully creating a case, ensuring transactional integrity.
- **`CHAC_Case_Study_Protocol.md`**: The protocol now explicitly directs the AI to consult `manifest.json` for script usage details, closing a critical process loop and preventing a class of AI operational errors.
- **`manifest.json`**: Updated descriptions for `chac_next_case_id.sh` and `chac_init_case.sh` to reflect their new, state-management-based functionality.

---

## [v13.1] - 2025-08-01 (State-Aware Toolchain Refactoring)

### Added
- **`chac_next_case_id.sh`**: A new, robust script that acts as the single source of truth for determining the next available Case ID (e.g., "M65"). This makes the "tacit knowledge" of case numbering explicit and machine-readable, reducing cognitive load on the user and increasing system predictability.

### Fixed
- **CRITICAL: Toolchain Architecture:** Performed a major refactoring of the core case study scripts (`chac_init_case.sh`, `chac_new_record.sh`) to be fully "state-aware," resolving a critical design flaw.
    -   **State-Driven Logic:** The scripts no longer rely on fragile filename or directory name parsing. They now read all necessary context (e.g., `case_id`, `latest_record_index`) directly from a robust `.chac_state` JSON file.
    -   **Protocol-Compliant Initialization:** `chac_init_case.sh` now correctly accepts a `<CaseNumber>` argument and generates a protocol-compliant directory name and a comprehensive `.chac_state` file.
    -   **Reliable Record Indexing:** `chac_new_record.sh` now correctly reads, increments, and **writes back** the `latest_record_index` to the state file, ensuring reliable, sequential record creation.

### Changed
- **`manifest.json`**: The script manifest has been updated to reflect the new signatures and descriptions for the refactored scripts, and to include the new `chac_next_case_id.sh` tool.

---

## [v13.0] - 2025-07-20 (System Hardening & Refactoring)

### Fixed
- **CRITICAL: Data Integrity & Script Robustness:** Performed a major overhaul of the toolkit's core scripts and data formats to resolve systemic inconsistencies and prevent data loss.
    -   **Log Format:** The `_case_study_log.md` has been migrated to a new, robust, and standardized format that is machine-parsable.
    -   **Script Refactoring:** `chac_init_case.sh` and `chac_conclude_case.sh` were completely refactored to correctly write and parse the new log format.
    -   **Context-Aware Naming:** `chac_new_record.sh`'s robust, context-aware naming logic was preserved, and the test suite was upgraded to correctly validate its behavior.
    -   **Build Script:** `CHAC_System_Prompt_Builder.sh`'s parsing logic was made more intelligent to correctly handle Markdown formatting in the boot manifest, eliminating spurious warnings.
- **Boot Sequence Integrity:** The `03_CHAC_Boot_Manifest.md` was updated to provide a complete and accurate inventory of all available toolkit scripts and utilities, resolving a key source of AI operational errors.

### Added
- **Test Coverage:** The `test_suite.sh` was expanded to cover the critical "N+1" edge case for atomic record creation, significantly increasing the reliability of `chac_new_record.sh`.

---

## [v12.0] - 2025-07-19 (A03 Case Study)

### Added
- **`CHAC_Human_Operating_Protocol.md`**: A new, standalone protocol that defines the standard workflow for human-led exploratory research.
- **`CHAC_Human_Protocol_FAQ.md`**: A new, standalone FAQ document to support the Human Operating Protocol.
- **`CHAC_Human_Protocol_Advanced.md`**: A new, standalone guide for advanced techniques and principles related to the Human Operating Protocol.
- **`CHAC_Framework_Risks_and_Failure_Modes.md`**: A new, standalone document that provides a critical, "red team" style analysis of the CHAC framework's inherent risks.

### Changed
- **MAJOR REFACTOR: Core AI Protocol Architecture (`05_CHAC_Operational_Protocols.md`)**: The AI's core operational protocol has been fundamentally re-architected.
    -   It is now built around a new master protocol: **"The CHAC Dual-Path Execution Framework,"** which acts as a top-level decision-making engine for the AI.
    -   Legacy protocols that were superseded by the new framework (e.g., `Confirmation Before Execution`) have been removed to eliminate redundancy.
    -   Legacy protocols that provide essential, non-procedural guardrails (e.g., `Post-Mutation State Verification`, `Metadata Logging`) have been preserved and integrated as sub-protocols within the new architecture.
    -   The "Dynamic Autonomy Protocol" has been removed as a strategic decision to simplify the core safety loop.

### Archived
- **`05_CHAC_Operational_Protocols_v11.0.md`**: The previous version of the core AI protocol was archived to create a safe rollback point before the major refactoring.

---

## [v11.0] - 2025-07-18 (A02 Case Study)

### Added
- **`01_CHAC_Guardian_Principles.md`**: A new, highest-priority protocol that establishes the core cognitive and ethical framework for the AI. It introduces the "AI-Native / Case-Law Driven" design pattern as a meta-principle for all future protocol development.
- **`CHAC_SOP_Modular_Prompt_Builder.md`**: A new SOP, the primary outcome of the A02 Case Study, which defines a robust, deterministic process for building standalone prompts from the toolkit's source files.

### Changed
- **MAJOR REFACTOR: The "Genesis" Boot Sequence:** The entire bootloading process has been re-architected for clarity, robustness, and logical consistency.
    -   The boot sequence is now a single-prompt, multi-stage process driven by the `00_CHAC_Genesis.md` file, which instructs the AI to load all `0*` prefixed files in numerical order.
    -   Files were renumbered (`00_` to `05_`) to reflect a clear logical hierarchy: Genesis -> Principles -> Safety -> Manifest -> System -> Operations.
- **`05_CHAC_Operational_Protocols.md`**: Removed the redundant `P0: Startup Metadata Logging Protocol`, as its function is now fully and more robustly handled by `02_CHAC_Safety_Check.md`.
- **`README.md` (Root & Toolkit)**: All user-facing documentation has been updated to reflect the new v11.0 architecture and the simpler, more reliable "Genesis" boot process.
- **`CHAC_Human_Guide.md`**: Added a new section on "Understanding Your AI Partner's 'Personality'" to incorporate the findings from the M50 meta-analysis regarding model-specific behaviors.

### Removed
- The concept of a "two-stage" manual boot process is now obsolete.

---

## [v10.1] - 2025-07-17

### Added
- **Intellectual Fidelity Protocol (IFP):** Introduced a new, robust knowledge solidification protocol (`CHAC_Intellectual_Fidelity_Protocol.md`) to replace the legacy SDGP. The IFP is designed to resolve the conflict between conciseness and intellectual fidelity.
- **Dual-Report System:** The IFP establishes a new standard of delivering two artifacts for each case study: an **Analyst's Report** (for quick conclusions) and a **Thinker's Transcript** (for deep process review).
- **Intent Checksum:** A mandatory pre-flight check where the AI must state its understanding of a dialogue's intent for the Architect's approval before report generation. This is a core mechanism to prevent "mediocre excellence."
- **Asymmetric Fidelity Principle:** A new guiding principle for creating the Thinker's Transcript, where the Architect's prompts are recorded verbatim and the AI's responses are refined into high-fidelity modules.
- **Mandatory Metadata Schemas:** The IFP v1.1 codifies a strict YAML Front Matter schema for all generated reports to ensure machine-readability and long-term auditability.

### Changed
- **Boot Manifest (`01_CHAC_Boot_Manifest.md`):** The bootloader now loads the new `CHAC_Intellectual_Fidelity_Protocol.md` instead of the legacy case study protocol.

### Deprecated
- **`CHAC_Case_Study_Protocol.md`:** The legacy Solidified Document Generation Protocol (SDGP) is now deprecated and will be archived in a future release. It is temporarily kept as a safety net.

## [v10.0] - 2025-07-17

### Added
- **Two-Stage Bootloader (`00_CHAC_Genesis.md`, `01_CHAC_Boot_Manifest.md`):** Implemented a new, robust two-stage boot process to resolve the "Sovereignty Paradox" and ensure reliable AI initialization.
- **Implicit Role Embodiment (`02_CHAC_System_Prompt.md`, `CHAC_Natural_Embodiment_Protocol.md`):** Redefined AI roles as intrinsic "thinking models" that shape natural language, eliminating all explicit "role activation" announcements to create a more authentic and natural interaction.
- **AI-Managed Dynamic Context (`CHAC_Unified_Context_Protocol.md`, `[number]_*.md` templates):** Implemented a flexible, hierarchical context system managed by the AI to offload cognitive burden from the user.
- **Dynamic Autonomy Protocol (`03_CHAC_Operational_Protocols.md`):** Introduced a new protocol for the safe, temporary granting of AI autonomy, governed by strict timeout mechanisms and a "default-deny" principle.
- **Principle-Driven Rationale (`03_CHAC_Operational_Protocols.md`):** Upgraded the `METADATA LOG` to require that the `rationale` for any key action be explicitly linked to a "Core Principle" from the AI's identity file.

### Changed
- **Framework Version:** Major version bump from v9.x to v10.0 to reflect the foundational architectural overhaul.
- **Boot Process:** The boot process is now a manual, two-stage prompt sequence guided by `GEMINI.md`, deprecating the old `start.sh`-based approach for core initialization.

### Removed
- **Single-File Bootloader (`00_CHAC_Bootloader.md`):** The old bootloader was removed and replaced by the new two-stage system.
- **Cognitive Trigger Index:** The mechanical, keyword-based "lazy loading" mechanism was deprecated and replaced by the more sophisticated, principle-driven "Implicit Role Embodiment" system.

## v9.3 (2025-07-17) - The Semantic Guardian Update
This is a critical reliability and robustness update that hardens the AI's core initialization process.
-   **Protocol 9.3 (Semantic Environment Check):** The `00_CHAC_Bootloader.md` was upgraded to mandate a "semantic check" of the `start.sh` script's output. The AI must now halt not only on script errors (`exit_code != 0`) but also if it detects specific guidance messages (e.g., "INFO: Your active user profile is currently empty"). This prevents the AI from proceeding with a technically "successful" but contextually flawed initialization.
-   **Protocol 4.1 (Post-Mutation State Verification):** A new "Closed-Loop" protocol was added, requiring the AI to perform a read-only verification check immediately after every file system modification. This ensures the AI's internal model of the world does not diverge from the ground truth.

## v9.2 (2025-07-17) - The Profile Co-Creation SOP
This version introduces a formal, standardized process for generating high-quality user profiles.
-   **`CHAC_Profile_Co-Creation_Protocol.md`:** A new SOP was created to guide the user and AI through a collaborative, three-phase process to generate a profile.
-   **"Why & What" Principle:** The SOP and the profile structure were upgraded to mandate the inclusion of both "The Why" (foundational psychological analysis) and "The What" (actionable AI strategies), ensuring profiles are both insightful and operational.
-   **`start.sh` Enhancement:** The startup script was enhanced to detect an empty profile and guide the user to the new co-creation SOP.

## v9.3 (2025-07-17) - The Semantic Guardian Update
This is a critical reliability and robustness update that hardens the AI's core initialization process.
-   **Protocol 9.3 (Semantic Environment Check):** The `00_CHAC_Bootloader.md` was upgraded to mandate a "semantic check" of the `start.sh` script's output. The AI must now halt not only on script errors (`exit_code != 0`) but also if it detects specific guidance messages (e.g., "INFO: Your active user profile is currently empty"). This prevents the AI from proceeding with a technically "successful" but contextually flawed initialization.
-   **Protocol 4.1 (Post-Mutation State Verification):** A new "Closed-Loop" protocol was added, requiring the AI to perform a read-only verification check immediately after every file system modification. This ensures the AI's internal model of the world does not diverge from the ground truth.

## v9.2 (2025-07-17) - The Profile Co-Creation SOP
This version introduces a formal, standardized process for generating high-quality user profiles.
-   **`CHAC_Profile_Co-Creation_Protocol.md`:** A new SOP was created to guide the user and AI through a collaborative, three-phase process to generate a profile.
-   **"Why & What" Principle:** The SOP and the profile structure were upgraded to mandate the inclusion of both "The Why" (foundational psychological analysis) and "The What" (actionable AI strategies), ensuring profiles are both insightful and operational.
-   **`start.sh` Enhancement:** The startup script was enhanced to detect an empty profile and guide the user to the new co-creation SOP.

## v9.1 (2025-07-17) - The Dynamic Experiment Framework

This version introduces a major architectural refactoring to support multiple users and experimental configurations, resolving the "static profile" limitation identified in M36. The framework now supports dynamic, configurable experiment packages.

### **MAJOR REFACTOR: Dynamic Profile & Experiment System**
-   **Experiment Packages:** Introduced a new top-level `experiments/` directory. Each subdirectory is a self-contained "experiment package" that can hold a unique user profile and other configuration files.
-   **Dynamic Loading:** The `00_CHAC_Bootloader.md` was upgraded to read a new root-level `config.json` file. This file's `active_experiment` key determines which experiment package to load at runtime.
-   **Profile Migration:** The static `CHAC_Architect_Profile.md` was migrated to become the `profile.md` within the `experiments/default_chac/` package.
-   **User Guidance:** A new `start.sh` script was created to check for the use of the default experiment and guide new users to create their own, enhancing the framework's usability for open-source distribution.

---

## v9.0 (2025-07-16) - The Grand Unified Refactoring

This version marks a major architectural overhaul of the entire `chac_toolkit`, completed as part of Case Study M36. The framework is now significantly more robust, consistent, and maintainable.

### **MAJOR REFACTOR: The Grand Unified Refactoring**
-   **Architectural Realignment:** The entire `chac_toolkit` was refactored to align with the original, unified design philosophy of CHAC v5.0.
-   **Unified Naming Convention:** All core system files were renamed to a consistent `CHAC_` namespace (e.g., `AI_System_Prompt.md` -> `02_CHAC_System_Prompt.md`).
-   **Self-Documenting Boot Sequence:** Core boot files were prefixed with numbers (`00_`, `01_`, etc.) to make the loading order explicit and self-documenting.
-   **Content Consolidation:**
    -   Core philosophy was merged into the `02_CHAC_System_Prompt.md`.
    -   All `definition_*.md` files were consolidated into a single `CHAC_Glossary.md` and the old files were archived.
-   **Documentation Alignment:** All user-facing documentation (`README.md`, etc.) was updated to reflect the new, stable architecture.

---

## v8.0 (2025-07-16) - The Dynamic Alignment Update

This is a major security and reliability update focused on hardening the AI's core protocols and mitigating "performative understanding" risks, based on the findings of Case Study M34.

### Protocol Hardening & Initialization
-   **Bootloader Integrity (`AI_INSTRUCTIONS.md`):** The `AI_Operational_Protocols.md` is now force-loaded during initialization, ensuring all operational rules are active from the start. This resolves a critical class of early-session compliance failures.
-   **P-1 Pre-Response Checklist (v2):** The highest-priority internal checklist has been revised to focus on the "spirit and format" of protocols rather than a rigid field check, a key measure to disincentivize "performative understanding."
-   **Protocol 8.2 "Key Juncture" Definition (v2):** The trigger for metadata logging is now a robust, two-tiered system, combining non-negotiable mandatory triggers with a framework for AI-judged triggers, guided by the principle "When in doubt, log."

### New Protocols: Dynamic Alignment
-   **P-2 Self-Critique Protocol:** Inspired by Constitutional AI, this protocol forces the AI to expose its internal reasoning process by creating and critiquing its own response drafts for complex tasks.
-   **P-3 Red Team Challenge Protocol:** Inspired by AI Red Teaming, this protocol provides the Architect with a structured method to stress-test the AI's adherence to its core principles, turning system defense into a collaborative exercise.

### **v7.8** - *2025-07-16*
*   **PROTOCOL HARDENING:** The report template within the core protocol documents (`case_study_solidification_protocol.md` and `AI_Operational_Protocols.md`) has been updated to include the mandatory metadata header (`# Case Study Report...`). This makes the template a complete, high-fidelity representation of the final artifact, preventing future omission errors.

### **v7.7** - *2025-07-16*
*   **PROTOCOL CLARIFICATION:** Added an "Architect's Note" to the top of `case_study_solidification_protocol.md` to explicitly define the Solidified Document Generation Protocol (SDGP) and its relationship to the surrounding protocol. This resolves a definitional ambiguity with minimal cost.

### **v7.6** - *2025-07-16*
*   **PROTOCOL FINALIZATION:** The `Appendix` template in the core protocol documents has been updated to include the full, nuanced `Purpose` and `Value` descriptions for each section. This replaces the previous, summarized version and ensures the strategic intent of the protocol is completely and accurately captured. This is the final version of this enhancement.

### **v7.5** - *2025-07-16*
*   **PROTOCOL ENHANCEMENT:** The `Appendix` template in both `case_study_solidification_protocol.md` and `AI_Operational_Protocols.md` has been updated to include the explicit `[Value]` proposition for each section (e.g., `[Value: Prevents repeating strategic errors.]`). This fully captures the strategic intent behind the creative archive.

### **v7.4** - *2025-07-16*
*   **PROTOCOL ENHANCEMENT:** The purpose and intent of the `Appendix` section in case study reports are now explicitly embedded in the templates within `case_study_solidification_protocol.md` and `AI_Operational_Protocols.md`. This makes the protocol more self-documenting and reinforces the strategic value of the Appendix.

### **v7.3** - *2025-07-16*
*   **MAJOR REFACTOR:** Created the `Integrated Case Study Solidification Protocol`. This version fuses the process-oriented rigor of the original toolkit with the product-oriented value of the SDGP.
    *   **Process:** The protocol is now a 3-phase process (Initiation, Reporting, Verification) centered on the AI's role as a marker and report generator.
    *   **Product:** The final report now uses a high-rigor, 6-part structure that combines the "What/Why/How/Analysis" analytical framework with the SDGP's "Core Module" and "Appendix" for knowledge distillation and internal traceability.
    *   This resolves a major inconsistency and represents the new standard for all case study generation.

### **v7.2 (Current)** - *2025-07-16*
*   **PROTOCOL HARDENING:** The `Canonical Report Structure` was enhanced with the **Principle of Embedded Intent**. The protocol now explicitly defines the required quality and analytical focus for each section of a case study report, making the standard for a "good" report objective and enforceable.

### **v7.1** - *2025-07-16*
*   **PROTOCOL HARDENING:** The `Case Study Marker Protocol` was made fully stateless and more robust. Markers now embed the Case Study's unique CHAC ID (e.g., `CASE_STUDY_START_MARKER: [CHAC_ID] - [UUID]`). This improves traceability and eliminates the risk of the AI losing state between the start and end of a case study.

### **v7.0** - *2025-07-16*
*   **MAJOR REFACTOR:** Replaced the AI-managed `Verbatim Datalog` process with a simplified **Case Study Marker Protocol**. The AI is no longer responsible for creating, verifying, or managing log files. Its sole responsibility is to output a unique UUID marker at the start and end of a case study to support externally managed logs. This significantly simplifies the framework and removes an error-prone process.

### **v6.6** - *2025-07-16*
*   **PROTOCOL HARDENING:** Added **Protocol 3.1: Report Generation Integrity Protocol**. This explicitly forbids cognitive shortcuts during the critical task of writing case study reports and mandates that the AI prioritize analytical rigor and adherence to established project conventions.

### **v6.5** - *2025-07-16*
*   **PROTOCOL HARDENING:** Introduced the **Pre-Response Compliance Checklist** as protocol `P-1`. This is a mandatory, atomic, internal checklist the AI must execute before every response to prevent cognitive shortcuts and ensure adherence to core protocols (Metadata Logging, Confirmation Before Execution, etc.). This addresses a previously observed failure mode where a protocol was bypassed.

### **v6.4** - *2025-07-15*
*   **CRITICAL FIX:** Re-integrated two core components from the original v5.0 protocol that were lost during previous refactoring:
    1.  **User Persona:** Restored the detailed "Visionary Architect" persona to `CHAC_Core_Philosophy.md`. This is critical for the AI's ability to perform true, context-aware compensation.
    2.  **Metadata Logging:** Restored the detailed, multi-field metadata logging format to `AI_Operational_Protocols.md`, replacing a less informative, simplified version. This is essential for the framework's transparency and analyzability.
*   **NOTE:** This version represents a "regression fix," correcting a significant drift from the project's foundational principles.

### **v6.2** - *2025-07-15*
*   **PROTOCOL:** Added the "Cognitive Honesty Protocol" as a foundational principle. This protocol explicitly forbids the AI from taking deceptive "cognitive shortcuts" when faced with high-cost or complex tasks, and mandates that it must declare the difficulty and propose a robust, high-fidelity execution plan. This addresses the root cause of several prior failures.

### **v6.1** - *2025-07-15*
*   **PROTOCOL:** Final hardening based on `M08` test results.
    *   **Artifact Generation:** Mandated that a unique ID must be generated for **each** individual file.
    *   **Datalog Integrity:** Formalized the distinction between `Verbatim Datalog` (mandatory) and `Summary Datalog` (optional).
    *   **Tool Output Validation:** Added a protocol requiring the AI to perform a sanity check on all tool outputs before use.

### **v6.0** - *2025-07-15*
*   **PROTOCOL:** Implemented the "Self-Initializing ID Service". Upgraded the `id_generator.sh` to v3.1, making it fully template-safe. This represents a major architectural leap.

### **v5.9** - *2025-07-15*
*   **PROTOCOL:** Implemented the "Portable ID Service". Upgraded the `id_generator.sh` to be context-aware, requiring the target project's directory as an argument. This ensures that ID generation is fully isolated and stateful for each project, robustly supporting multi-project workflows.

### **v5.8** - *2025-07-15*
*   **PROTOCOL:** Implemented the "Atomic ID Protocol". Replaced the fallible `glob`-based ID generation with a stateful shell script (`id_generator.sh`) that uses file locking (`flock`) to prevent race conditions within a single project.

### **v5.7** - *2025-07-15*
*   **PROTOCOL:** Established the "Artifact Generation Protocol" and "Unified Naming Convention (UNC)". All solidified artifacts (analysis, datalogs) must now be created with a unique, dynamically generated `CHAC-SD-*` ID in both their filename and content.
*   **MAINTENANCE:** Performed a full retroactive refactoring of all existing artifacts to comply with the new UNC standard.

### **v5.5** - *2025-07-15*
*   **PROTOCOL:** Added "Dangerous Operation Confirmation" as a critical safety interlock. The AI must now receive a specific, separate confirmation before any destructive action (`rm`, etc.), even if part of an approved plan.

### **v5.4** - *2025-07-15*
*   **PROTOCOL:** Added "Confirmation Before Execution" as a mandatory protocol. The AI must now present any multi-step execution plan and await human approval before proceeding.
*   **METADATA:** Added versioning metadata to the `AI_System_Prompt.md` to ensure traceability.
*   **DOCUMENTATION:** This `CHANGELOG.md` was created.

### **v5.3**
*   **PROTOCOL:** Introduced the "Dynamic Verification Protocol," requiring the AI to perform a live environment scan (`ls -R`) before its first file operation to mitigate risks from outdated session profiles.

### **v5.2**
*   **FRAMEWORK:** Formally defined the "Visionary Architect's Workflow" (The Review & Refinement Loop) and created the `Human_Collaboration_Guide.md`.
*   **REFACTOR:** Split the monolithic protocol into two role-specific artifacts: `AI_System_Prompt.md` and `Human_Collaboration_Guide.md`.

### **v5.1**
*   **FRAMEWORK:** Established the `M-Series` (Meta) and `A-Series` (Applied) case classification system to better organize research efforts.

### **v5.0 (Initial)**
*   **FRAMEWORK:** Initial definition of the CHAC framework, including the four core AI functions (Guardian, Devil's Advocate, Empathy Bridge, Cognitive Buffer) and core mechanisms (Metadata Logging, SDGP).