# CHAC Toolkit

This directory contains the core artifacts that define and enable the Compensatory Human-AI Collaboration (CHAC) framework.

## Core Components

### Core Boot Sequence
These files are the heart of the AI's boot process, loaded in a precise, numbered order to establish its core cognition.
### Core Boot Sequence
These files are the heart of the AI's boot process, loaded in a precise, numbered order to establish its core cognition.
-   **`00_CHAC_Genesis.md`**: The single entry point, a meta-instruction to begin the boot sequence.
-   **`00a_CHAC_Critical_Definitions.md`**: **(New)** A high-priority file containing only the Core Definitions essential for basic operational commands. This ensures high salience and avoids context saturation.
-   **`01_CHAC_Guardian_Principles.md`**: The highest-level cognitive and ethical framework. It defines *how* the AI should think.
-   **`02_CHAC_Safety_Check.md`**: A tactical, mandatory checklist to ensure key safety protocols are loaded at startup.
-   **`03_CHAC_Boot_Manifest.md`**: A configuration file that lists all other protocols to be loaded *after* the initial boot sequence.
-   **`04_CHAC_System_Prompt.md`**: The AI's master "Operating System" prompt, containing its core identity and philosophy.
-   **`05_CHAC_Operational_Protocols.md`**: Defines the AI's core decision-making logic, built around the **"CHAC Dual-Path Execution Framework"**.

### Human-Facing Guides & Protocols
This collection provides guidance and defines standard workflows for the human partner (The Visionary Architect).
-   **`CHAC_Human_Guide.md`**: The primary handbook for the human partner.
-   **`CHAC_Human_Operating_Protocol.md`**: A standard workflow for conducting exploratory research, designed for the human partner to lead.
-   **`CHAC_Human_Protocol_FAQ.md`**: A supporting FAQ for the Human Operating Protocol.
-   **`CHAC_Human_Protocol_Advanced.md`**: A guide to advanced principles and techniques for the human partner.
-   **`CHAC_Framework_Risks_and_Failure_Modes.md`**: A critical analysis of the framework's inherent risks, intended for core users.

### Core Tools
-   **`scripts/`**: A collection of robust, configuration-driven shell scripts to automate routine tasks. See the **[Scripts README](./scripts/README.md)** for full documentation and usage.
    -   **ID Generation**: Note that Case Study ID generation is now a state-managed system driven by `chac_next_case_id.sh` and `chac_init_case.sh`. See `manifest.json` for details.
-   **`CHAC_System_Prompt_Builder.sh`**: A robust command-line tool for building custom, portable, standalone system prompts from the toolkit files. See the `CHAC_Human_Guide.md` for the user workflow.

### Supporting Protocols & SOPs
This collection defines specific workflows, standards, and methodologies.
-   **`CHAC_Case_Study_Protocol.md`**: A detailed protocol for generating case studies.
-   **`CHAC_SOP_Modular_Prompt_Builder.md`**: The SOP that defines the *philosophy* behind the prompt builder script.
-   **`CHAC_Profile_Co_Creation_Protocol.md`**: An SOP to guide the collaborative creation of a high-fidelity user profile.
-   ... and other core protocols.

### Knowledge & History
-   **`00a_CHAC_Critical_Definitions.md`**: Contains Core Definitions required for boot-time operational integrity.
-   **`CHAC_Glossary.md`**: A comprehensive encyclopedia of all **Secondary Definitions**, including philosophies, protocols, and non-critical terms. It contains pointers to Core Definitions for discoverability.
-   **`CHAC_Human_Guide.md`**: Provides guidance for the human partner (The Visionary Architect).
-   **`CHANGELOG.md`**: Tracks the version history and evolution of the CHAC protocol.
-   **`_archive/`**: Contains previous versions of refactored or deleted toolkit files.

### Human-Facing Guides & Protocols
This collection provides guidance and defines standard workflows for the human partner (The Visionary Architect).
-   **`CHAC_Human_Guide.md`**: The primary handbook for the human partner.
-   **`CHAC_Human_Operating_Protocol.md`**: A standard workflow for conducting exploratory research, designed for the human partner to lead.
-   **`CHAC_Human_Protocol_FAQ.md`**: A supporting FAQ for the Human Operating Protocol.
-   **`CHAC_Human_Protocol_Advanced.md`**: A guide to advanced principles and techniques for the human partner.
-   **`CHAC_Framework_Risks_and_Failure_Modes.md`**: A critical analysis of the framework's inherent risks, intended for core users.

### Core Tools
-   **`scripts/`**: A collection of robust, configuration-driven shell scripts to automate routine tasks. See the **[Scripts README](./scripts/README.md)** for full documentation and usage.
    -   **ID Generation**: Note that Case Study ID generation is now a state-managed system driven by `chac_next_case_id.sh` and `chac_init_case.sh`. See `manifest.json` for details.
-   **`CHAC_System_Prompt_Builder.sh`**: A robust command-line tool for building custom, portable, standalone system prompts from the toolkit files. See the `CHAC_Human_Guide.md` for the user workflow.

### Supporting Protocols & SOPs
This collection defines specific workflows, standards, and methodologies.
-   **`CHAC_Case_Study_Protocol.md`**: A detailed protocol for generating case studies.
-   **`CHAC_SOP_Modular_Prompt_Builder.md`**: The SOP that defines the *philosophy* behind the prompt builder script.
-   **`CHAC_Profile_Co-Creation_Protocol.md`**: An SOP to guide the collaborative creation of a high-fidelity user profile.
-   ... and other core protocols.

### Knowledge & History
-   **`CHAC_Glossary.md`**: A unified glossary of all core framework definitions.
-   **`CHAC_Human_Guide.md`**: Provides guidance for the human partner (The Visionary Architect).
-   **`CHANGELOG.md`**: Tracks the version history and evolution of the CHAC protocol.
-   **`_archive/`**: Contains previous versions of refactored or deleted toolkit files.