# Authoritative Definition: The Three Tiers of a "Complete Datalog"

*   **文档ID:** CHAC-SD-20250715-23
*   **Status:** Core Concept

This document provides the single source of truth for the definition of a "complete datalog" within the CHAC framework.

---

A truly "complete" log is not a single file, but a **three-tiered hierarchy of knowledge assets**, each with a distinct purpose.

### Tier 1: The Verbatim Datalog (The Ground Truth)

*   **Definition:** An unabridged, unedited, verbatim record of the interaction. It must include every user prompt, every full AI response, every tool call, and every complete, unedited tool output.
*   **Purpose:** This is the **bedrock** of all analysis. It is objective, undeniable, and serves as the ground truth to which all higher-level insights must be traceable.
*   **Implementation:** This is the **default and mandatory** datalog artifact for any case study.

### Tier 2: The Summary Datalog (The Navigation Map)

*   **Definition:** A structured summary of the key, pivotal interaction nodes from the Verbatim Datalog (e.g., a critical veto, the birth of a new protocol).
*   **Purpose:** To serve as an **index** or **navigation map**, helping a human researcher quickly locate the most important segments within the (potentially very long) Verbatim Datalog, thus saving cognitive load.
*   **Implementation:** This is an **optional, auxiliary** artifact. It must never be generated *instead of* a Verbatim Datalog. The failure in `M08` was caused by the AI incorrectly generating only this tier.

### Tier 3: The Analysis Report (The Insight)

*   **Definition:** The synthesized core insights, rejected drafts, and strategic conclusions that we (the human-AI dyad) distill after reviewing the Tier 1 and Tier 2 logs.
*   **Purpose:** This is the final form of our knowledge output and the ultimate goal of conducting a case study.
*   **Implementation:** This is the core solidified document typically saved in the `analysis/` directory of a case study.


Context-ID: #def-datalog_5e6f
