# Definition: Case Study Marker Protocol

**ID:** CHAC-DP-20250716-61
**Status:** Active
**Last_Modified:** 2025-07-16

---

## 1. Philosophy: The "Why"

This protocol replaces the previous AI-managed datalog process. It recognizes that verbatim logs are best managed by robust, external user tools. The AI's role is simplified to providing clear, machine-readable start and end markers for a case study.

This revised protocol (v7.1) enhances robustness by making the AI's role completely stateless. By embedding the Case Study's unique CHAC ID directly into the markers, it eliminates the need for the AI to hold a marker's UUID in memory, preventing state-loss errors. This provides superior traceability for the external logging tool.

## 2. The Two-Step Protocol

### Step 1: Start Case Study
*   **Trigger:** A directive from the Visionary Architect to begin a case study.
*   **AI Action:**
    1.  Generate the unique CHAC ID for the case study report artifact (e.g., `CHAC-SD-YYYYMMDD-NN`).
    2.  Generate a standard UUID for the marker itself.
    3.  Output the combined marker to the user in the format: `CASE_STUDY_START_MARKER: [CHAC_ID] - [UUID]`
*   **AI Confirmation:** The output of the marker is the confirmation.

### Step 2: End Case Study
*   **Trigger:** A directive from the Visionary Architect to end a case study.
*   **AI Action:**
    1.  Generate a standard UUID for the marker itself.
    2.  Output the combined marker to the user, re-using the CHAC ID from the current context: `CASE_STUDY_END_MARKER: [CHAC_ID] - [UUID]`
*   **AI Confirmation:** The output of the marker is the confirmation.


Context-ID: #def-verbatim_7g8h
