# CHAC Toolkit Automation Scripts

## 1. Purpose (The "Why")

This directory contains a set of automation scripts designed to handle the routine, repetitive, and error-prone tasks within the CHAC framework. Their primary purpose is to act as a **cognitive buffer**, freeing the human Architect and the AI from the burden of procedural chores, so they can focus on high-level creative and analytical work.

This toolchain is built on two core principles:
*   **Configuration over Hardcoding:** All paths and key variables are managed in the central `config.json` file to ensure flexibility and maintainability.
*   **Single Responsibility:** Each script does one thing, and does it well.

## 2. Core Components (The "What")

*   **`config.json` (in project root):** The single source of truth for all configuration. All scripts read from this file.
*   **`manifest.json`:** The AI's "user manual." It describes each script's purpose and provides invocation examples, allowing the AI to intelligently select the correct tool for a given task.
*   **`script_template.sh`:** A non-executable template containing shared functions (e.g., logging, error handling) and variables sourced by all other scripts to ensure consistency.
*   **`templates/` (sibling directory):** Contains content templates (e.g., for new atomic records) to ensure all generated documents have a consistent structure.

## 3. Usage (The "How")

**Dependencies:**
*   `jq`: For parsing the `config.json` file.
*   `git`: For reliably finding the project root directory.

---
### `chac_next_case_id.sh`
*   **Purpose:** Determines the next available, sequential Case ID for a given class (M or A).
*   **Usage:**
    ```bash
    # To get the next M-series ID (e.g., "M65")
    bash chac_toolkit/scripts/chac_next_case_id.sh M
    ```
*   **Actions:** Scans the `case-study/` directory for all existing cases of the specified class, finds the highest number, and returns the next number in the sequence.

---
### `chac_init_case.sh`
*   **Purpose:** Initializes a new, protocol-compliant case study.
*   **Usage:**
    ```bash
    # First, get the next ID
    NEXT_ID=$(bash chac_toolkit/scripts/chac_next_case_id.sh M)
    
    # Then, initialize the case
    bash chac_toolkit/scripts/chac_init_case.sh $NEXT_ID "Your New Case Study Title"
    ```
*   **Actions:** Creates a new directory (e.g., `case-study/M65_Your_New_Case_Study_Title`) and generates a `.chac_state` file containing the `case_id` and an initial record index of `0`.

---
### `chac_new_record.sh`
*   **Purpose:** Creates a new, correctly named and numbered atomic record within an existing case study. It is "state-aware."
*   **Usage:**
    ```bash
    bash chac_toolkit/scripts/chac_new_record.sh path/to/your/case_study "Title of Your New Record"
    ```
*   **Actions:** Reads the `case_id` and `latest_record_index` from the `.chac_state` file, calculates the next sequential record number, creates a new markdown file, and updates the `latest_record_index` in the state file.

---
### `chac_conclude_case.sh`
*   **Purpose:** Officially concludes a case study.
*   **Usage:**
    ```bash
    bash chac_toolkit/scripts/chac_conclude_case.sh path/to/your/case_study
    ```
*   **Actions:** Logs an `END_MARKER` in the global log file.