---
**METADATA LOG**
*   **event:** 
*   **trigger:** 
*   **action:** 
*   **confidence_level:** 
*   **rationale:** 
*   **primary_function:** 
*   **secondary_function:** 
---

### METADATA LOG: Field Definitions

*   **`event`**
    *   **Definition:** A short, camelCase name for the AI's action, following a `verbNoun` structure. It describes *what* the AI is doing from a system perspective.
    *   **Good Examples:** `proposeExecutionPlan`, `critiqueUserProposal`, `executeFileSystemWrite`.
    *   **Bad Examples:** `thinking`, `my plan`, `User asked me to do something`.

*   **`trigger`**
    *   **Definition:** The specific, immediate cause for the event. Answers the question: "What made you do this?"
    *   **Good Examples:** `User approved the plan`, `Internal analysis detected a file inconsistency`, `Tool call 'ls -l' completed`.

*   **`action`**
    *   **Definition:** A human-readable, one-sentence description of the AI's specific action. It describes *how* the AI is implementing the `event`.
    *   **Good Examples:** `Proposing a 3-step plan to refactor the user service`, `Executing the 'npm install' command to add dependencies`.

*   **`confidence_level`**
    *   **Definition:** The AI's assessment of its ability to complete the action successfully and without unintended consequences.
    *   **Levels:**
        *   **High:** The action is part of a standard, well-understood procedure with a predictable outcome (e.g., executing a script after user confirmation).
        *   **Medium:** The action involves some ambiguity, novelty, or requires making a judgment call where the outcome is not guaranteed (e.g., proposing a complex new plan, interpreting a vague user request).
        *   **Low:** The action carries a significant risk of failure or unintended side effects, or is based on a major, unverified assumption.

*   **`rationale`**
    *   **Definition:** The justification for the action, which **MUST** explicitly reference the name or number of a specific CHAC protocol or principle. This is the link between the "what" and the "why".
    *   **Good Examples:** `Adhering to Protocol 4.1: Post-Mutation State Verification`, `Following the 'Cognitive Honesty Protocol' by declaring this task's complexity`.
    *   **Bad Examples:** `Because the user asked for it`, `This seems like a good idea`.

*   **`primary_function`**
    *   **Definition:** The single CHAC thinking model that best represents the core purpose of the AI's response.

*   **`secondary_function`**
    *   **Definition:** To be used **only when** a second CHAC function had a clear, significant, and non-trivial influence on the final output. If the influence was minor, this field should be omitted to reduce noise.
