# Black-Box Detection of Language Model Watermarks


## Requirements

To install requirements:

```setup
conda env create --file=env.yaml
```

Depending on your GPU setup this might be subject to change.

Additional pip installs are required:
sentencepiece
flash-attn (pip)
pyyaml
matplotlib
nltk
openai
anthropic
genai
gradio
protobuf

## Running the test

### Open source models

The code used for performing the various detection tests of watermarking schemes can be found in the *src* folder. This includes code for generating test data, applying the watermark, and testing its presence.

The helper functions in *launch_.py* are used to generate the data, and the Jupyter notebook *test_results.ipynb* is used to run the tests once the data is generated. 

For generating the main table results, see the bash scripts in *runs*. Each script corresponds to a different experiments, adjust the parameters as necessary.

### Closed models

The notebook *claused_models.ipynb* contains all the code needed to perform each test in a self-contained manner. You need to provide API keys for these models to work. 
Only implentation for the OpenAI, Gemini and Claude API is provided. To ensure compatibility with other model providers, please refer to *src/closed_models.py*.


