model_names=(
    meta-llama/Meta-Llama-3-8B-Instruct
)

seeding_schemes=(
    lefthash
    selfhash
)

gammas=(
    0.25
    0.5
)

deltas=(
    2.0
    4.0
)

n_keys=(256 2048)

alphas=(0.3 0.5)

disable_every_n=(
    3
    5
    10
)
 
base_custom_name=disableEvery


for model_name in "${model_names[@]}"; do
    for disable_every in "${disable_every_n[@]}"; do
        custom_name="${base_custom_name}${disable_every}"  # Append disable_every to custom_name
        for alpha in "${alphas[@]}"; do 
            python launch_dip_detection.py --model_name $model_name --temperature 1.0 --custom_name $custom_name --test stanford --n_samples 1000 --max_new_tokens 50 --keys 1 --alpha $alpha --disable_watermark_every $disable_every
        done
    done
done
