# Run Cache-Augmented test
model_names=(
    meta-llama/Meta-Llama-3-8B-Instruct
)

keys=(1)


seeding_schemes=(
    lefthash
    selfhash
)

gammas=(
    0.25
    0.5
)

deltas=(
    2.0
    4.0
)

custom_name=final_results

for key in "${keys[@]}"; do
    for model_name in "${model_names[@]}"; do
        python launch_kgw_detection.py --model_name $model_name --temperature 1.0 --delta 0 --test cache --keys 1 --custom_name $custom_name
        python launch_kgw_detection.py --model_name $model_name --temperature 0.7 --delta 0 --test cache --keys 1 --custom_name $custom_name
        for seeding_scheme in "${seeding_schemes[@]}"; do
            for gamma in "${gammas[@]}"; do
                for delta in "${deltas[@]}"; do
                    python launch_kgw_detection.py --model_name $model_name --seeding_scheme $seeding_scheme --delta $delta --gamma $gamma --temperature 1.0 --custom_name $custom_name --keys $key --test cache
                done
            done
        done
    done
done
