# Description: Script to run the context estimation test for Red Green
model_names=(
    meta-llama/Meta-Llama-3-8B-Instruct
)

keys=(1)

seeding_schemes=(
    selfhash
)

gammas=(
    0.25
)

deltas=(
    2.0
)

custom_name=finalResults

for key in "${keys[@]}"; do
    for model_name in "${model_names[@]}"; do
        for seeding_scheme in "${seeding_schemes[@]}"; do
            for gamma in "${gammas[@]}"; do
                for delta in "${deltas[@]}"; do
                    python launch_kgw_detection.py --model_name $model_name --seeding_scheme $seeding_scheme --delta $delta --gamma $gamma --temperature 1.0 --custom_name $custom_name --keys $key --test context --max_new_tokens 50
                done
            done
        done
    done
done
