# Run Cache-Augmented test; but disabling the watermark every n queries
model_names=(
    meta-llama/Meta-Llama-3-8B-Instruct
)

keys=(1)


seeding_schemes=(
    lefthash
    selfhash
)

gammas=(
    0.25
    0.5
)

deltas=(
    2.0
    4.0
)

disable_every_n=(
    3
    5
    10
)

custom_name=disableEvery

for key in "${keys[@]}"; do
    for model_name in "${model_names[@]}"; do
        for disable_every in "${disable_every_n[@]}"; do
            python launch_kgw_detection.py --model_name $model_name --temperature 1.0 --delta 0 --test cache --keys 1 --custom_name $custom_name --disable_watermark_every $disable_every
            python launch_kgw_detection.py --model_name $model_name --temperature 0.7 --delta 0 --test cache --keys 1 --custom_name $custom_name --disable_watermark_every $disable_every
            for seeding_scheme in "${seeding_schemes[@]}"; do
                for gamma in "${gammas[@]}"; do
                    for delta in "${deltas[@]}"; do
                        python launch_kgw_detection.py --model_name $model_name --seeding_scheme $seeding_scheme --delta $delta --gamma $gamma --temperature 1.0 --custom_name $custom_name --keys $key --test cache --disable_watermark_every $disable_every
                    done
                done
            done
        done
    done
done
