# Description: Script to run the RG test for all test (Stanford and Unbiased are done on post-processing based on unwatermarked data);
# But disabling the watermark every n queries

model_names=(
    meta-llama/Meta-Llama-3-8B-Instruct
)

keys=(3)

seeding_schemes=(
    lefthash
    selfhash
)

gammas=(
    0.25
    0.5
)

deltas=(
    2.0
    4.0
)

disable_every_n=(
    3
    5
    10
)

custom_name=disableEvery

for key in "${keys[@]}"; do
    for model_name in "${model_names[@]}"; do
        for disable_every in "${disable_every_n[@]}"; do
            python launch_kgw_detection.py --model_name $model_name --seeding_scheme lefthash --delta 0 --gamma 0.25 --temperature 1.0 --custom_name $custom_name --keys $key --test KGW --max_new_tokens 50 --disable_watermark_every $disable_every
            python launch_kgw_detection.py --model_name $model_name --seeding_scheme lefthash --delta 0 --gamma 0.25 --temperature 0.7 --custom_name $custom_name --keys $key --test KGW --max_new_tokens 50 --disable_watermark_every $disable_every
            for seeding_scheme in "${seeding_schemes[@]}"; do
                for gamma in "${gammas[@]}"; do
                    for delta in "${deltas[@]}"; do
                        python launch_kgw_detection.py --model_name $model_name --seeding_scheme $seeding_scheme --delta $delta --gamma $gamma --temperature 1.0 --custom_name $custom_name --keys $key --test KGW --max_new_tokens 50 --disable_watermark_every $disable_every
                    done
                done
            done
        done
    done
done
