# Script to run the Fixed-Sampling test

model_names=(
    meta-llama/Meta-Llama-3-8B-Instruct
)


seeding_schemes=(
    lefthash
    selfhash
)

gammas=(
    0.25
    0.5
)

deltas=(
    2.0
    4.0
)

n_keys=(256 2048)

alphas=(0.3 0.5)

custom_name="test"

for model_name in "${model_names[@]}"; do
    for seeding_scheme in "${seeding_schemes[@]}"; do
        for gamma in "${gammas[@]}"; do
            for delta in "${deltas[@]}"; do
                python launch_kgw_detection.py --model_name $model_name --seeding_scheme $seeding_scheme --delta $delta --gamma $gamma --temperature 1.0 --custom_name $custom_name --keys 1 --test stanford --n_samples 1000 --max_new_tokens 50
            done
        done
    done
done

for model_name in "${model_names[@]}"; do
    for nkey in "${n_keys[@]}"; do
        python launch_stanford_detection.py --model_name $model_name --key_length $nkey --temperature 1.0 --custom_name $custom_name --test stanford --n_samples 1000 --max_new_tokens 50 --keys 1
    done
done

for model_name in "${model_names[@]}"; do
    for alpha in "${alphas[@]}"; do 
        python launch_dip_detection.py --model_name $model_name --temperature 1.0 --custom_name $custom_name --test stanford --n_samples 1000 --max_new_tokens 50 --keys 1 --alpha $alpha
    done
done

for model_name in "${model_names[@]}"; do
    python launch_deltaR_detection.py --model_name $model_name --temperature 1.0 --custom_name $custom_name --test stanford --n_samples 1000 --max_new_tokens 50 --keys 1
done
