# B4MRL
Data and simulators for hybrid online-offline-RL tasks.

1. The simulators are biased by one of several predetermined options.
2. The data is biased by several predetermined hidden-confounder options.
3. (TODO) Additional data is added that model biases in the data-creation task.

To create an instance of the required env make sure first register all envs by:
```
import sim
import offline_data
```

To create a biased env run gym.make with the following id pattern:
```
[env_type]-[error_type]-[error_variant]-[variant_value]-v0
```
For example:
```
gym.make('halfcheetah-action-error-noise-0.05-v0')
```

If data is used, the data-type should also be added beterrn env_type and error_type.
For example:
```
gym.make('halfcheetah-medium-confounding-error-noise-0.05-v0')
```

For creating an environment with transition error (which we also name modeling error in the paper), first make sure the xml file is in the xmls directory.
The environment needs to be made with the specific transition error necessary in between the name of the dataset and the version.
For example:
```
gym.make('halfcheetah-medium-transition-error-gravity-2-v2')
```


We add several other options for different datasets
```
halfcheetah-ds-obs-hidden-dims-9
halfcheetah-ds-obs-hidden-dims-9-stacked-3
halfcheetah-ds-obs-hidden-dims-163333333
halfcheetah-ds-obs-hidden-dims-16-stacked-3
```
To be able to run these added environments, please first download them from the anonymized one-drive links below:

https://1drv.ms/f/s!Ah0CJrMl_CR5aWFOrFlTkszgWFA?e=6tFfWp
https://1drv.ms/f/s!Ah0CJrMl_CR5ajSX_rJ8SRuFv9M?e=xNinha
https://1drv.ms/f/s!Ah0CJrMl_CR5a7MokfQqBMj3YrA?e=bnZ9b3
https://1drv.ms/f/s!Ah0CJrMl_CR5bEKnpytXfaEr6cM?e=btRyFC

After downloading, please move all the downloaded folders to the data folder, and then gym.make with the above ids should work.
