from .halfcheetah import StaticFns as halfcheetah_static_fn
from .hopper import StaticFns as hopper_static_fn
from .walker2d import StaticFns as walker2d_static_fn


def get_static_fn(env_type):
    if env_type == 'HalfCheetah':
        return halfcheetah_static_fn
    elif env_type == 'Hopper':
        return hopper_static_fn
    elif env_type == 'Walker2d':
        return walker2d_static_fn
    else:
        raise ValueError(f'{env_type} is not supprted. Use [halfcheetah/hopper/walker2d]')
